/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.debug.core.sourcelookup;

import com.aptana.debug.core.DebugCorePlugin;
import com.aptana.debug.core.sourcelookup.RemoteFileStorage;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;

public class RemoteSourceContainer
extends AbstractSourceContainer {
    public Object[] findSourceElements(String path) throws CoreException {
        try {
            URI uri = new URI(path);
            String scheme = uri.getScheme();
            if ("http".equals(scheme) || "https".equals(scheme) || "dbgsource".equals(scheme)) {
                RemoteFileStorage storage = DebugCorePlugin.getDefault().getRemoteSourceCacheManager().getStorage(uri);
                if (storage == null) {
                    storage = new RemoteFileStorage(uri, null);
                    DebugCorePlugin.getDefault().getRemoteSourceCacheManager().add(uri, storage);
                }
                return new Object[]{storage};
            }
        }
        catch (URISyntaxException ignore) {
            ignore.getCause();
        }
        return EMPTY;
    }

    public String getName() {
        return "Remote File Source Container";
    }

    public ISourceContainerType getType() {
        return null;
    }
}

