/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.debug.core.sourcelookup;

import com.aptana.core.io.efs.EFSUtils;
import com.aptana.debug.core.sourcelookup.Messages;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;

public class LocalFileSourceContainer
extends AbstractSourceContainer {
    public Object[] findSourceElements(String uriString) throws CoreException {
        IFile resource;
        URI uri = null;
        try {
            uri = new URI(uriString);
            if (uri.getScheme() == null) {
                uri = null;
            }
        }
        catch (URISyntaxException ignore) {
            ignore.getCause();
        }
        if (uri == null && (resource = ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromPortableString((String)uriString))) != null) {
            uri = EFSUtils.getFileStore((IResource)resource).toURI();
        }
        if (uri != null) {
            String scheme = uri.getScheme();
            if ("http".equals(scheme) || "https".equals(scheme)) {
                return EMPTY;
            }
            IFileStore fileStore = EFS.getStore((URI)uri);
            if (fileStore.fetchInfo().exists()) {
                IResource resource2 = (IResource)fileStore.getAdapter(IResource.class);
                if (resource2 != null && resource2.exists()) {
                    return new Object[]{resource2};
                }
                File file = (File)fileStore.getAdapter(File.class);
                if (file != null && file.isFile()) {
                    return new Object[]{fileStore};
                }
                file = fileStore.toLocalFile(4096, (IProgressMonitor)new NullProgressMonitor());
                if (file != null && file.isFile()) {
                    return new Object[]{fileStore};
                }
            }
        }
        return EMPTY;
    }

    public String getName() {
        return Messages.JSSourceContainer_LocalFileSourceContainer;
    }

    public ISourceContainerType getType() {
        return null;
    }
}

