/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.debug.core;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.resources.IUniformResourceMarker;
import com.aptana.core.util.EclipseUtil;
import com.aptana.debug.core.DebugCorePlugin;
import com.aptana.debug.core.DetailFormatter;
import com.aptana.debug.core.IDetailFormattersChangeListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.osgi.service.prefs.BackingStoreException;

public final class DebugOptionsManager
implements IDebugEventSetListener {
    private static final String DEBUGGER_ACTIVE_SUFFIX = ".debuggerActive";
    public static final String DETAIL_FORMATTER_IS_ENABLED = "1";
    public static final String DETAIL_FORMATTER_IS_DISABLED = "0";
    private final String modelIdentifier;
    private final ListenerList changeListeners = new ListenerList();
    private IEclipsePreferences.IPreferenceChangeListener preferenceChangeListener;
    private Map<String, DetailFormatter> fDetailFormattersMap;

    public DebugOptionsManager(String modelIdentifier) {
        this.modelIdentifier = modelIdentifier;
    }

    public void startup() {
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        this.populateDetailFormattersMap();
        this.preferenceChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (DebugOptionsManager.this.getDetailFormattersPrefName().equals(event.getKey())) {
                    DebugOptionsManager.this.populateDetailFormattersMap();
                    DebugOptionsManager.this.notifyChangeListeners();
                }
            }
        };
        EclipseUtil.instanceScope().getNode("com.aptana.debug.core").addPreferenceChangeListener(this.preferenceChangeListener);
    }

    public void shutdown() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        EclipseUtil.instanceScope().getNode("com.aptana.debug.core").removePreferenceChangeListener(this.preferenceChangeListener);
    }

    public static boolean isDebuggerActive(String modelIdentifier) {
        return "true".equals(System.getProperty(String.valueOf(modelIdentifier) + DEBUGGER_ACTIVE_SUFFIX));
    }

    public Collection<DetailFormatter> getDetailFormatters() {
        return this.fDetailFormattersMap.values();
    }

    public void setDetailFormatters(Collection<DetailFormatter> formatters) {
        this.fDetailFormattersMap.clear();
        for (DetailFormatter formatter : formatters) {
            this.fDetailFormattersMap.put(formatter.getTypeName(), formatter);
        }
        this.savePreferences();
    }

    public void setAssociatedDetailFormatter(DetailFormatter detailFormatter) {
        this.fDetailFormattersMap.put(detailFormatter.getTypeName(), detailFormatter);
        this.savePreferences();
    }

    public void removeAssociatedDetailFormatter(DetailFormatter detailFormatter) {
        this.fDetailFormattersMap.remove(detailFormatter.getTypeName());
        this.savePreferences();
    }

    public boolean hasAssociatedDetailFormatter(String typeName) {
        return this.fDetailFormattersMap.containsKey(typeName);
    }

    public DetailFormatter getAssociatedDetailFormatter(String typeName) {
        return this.fDetailFormattersMap.get(typeName);
    }

    public void addChangeListener(IDetailFormattersChangeListener listener) {
        this.changeListeners.add((Object)listener);
    }

    public void removeChangeListener(IDetailFormattersChangeListener listener) {
        this.changeListeners.remove((Object)listener);
    }

    public static String[] parseList(String listString) {
        ArrayList<String> list = new ArrayList<String>(10);
        StringTokenizer tokenizer = new StringTokenizer(listString, ",");
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    public static String serializeList(String[] list) {
        if (list == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < list.length) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(list[i]);
            ++i;
        }
        return buffer.toString();
    }

    private String getDetailFormattersPrefName() {
        return String.valueOf(this.modelIdentifier) + ".detail_formatters";
    }

    private void populateDetailFormattersMap() {
        String[] detailFormattersList = DebugOptionsManager.parseList(EclipseUtil.instanceScope().getNode("com.aptana.debug.core").get(this.getDetailFormattersPrefName(), ""));
        this.fDetailFormattersMap = new HashMap<String, DetailFormatter>(detailFormattersList.length / 3);
        int i = 0;
        int length = detailFormattersList.length;
        while (i < length) {
            String typeName = detailFormattersList[i++];
            String snippet = detailFormattersList[i++].replace('\u0000', ',');
            boolean enabled = !DETAIL_FORMATTER_IS_DISABLED.equals(detailFormattersList[i++]);
            this.fDetailFormattersMap.put(typeName, new DetailFormatter(typeName, snippet, enabled));
        }
    }

    private void savePreferences() {
        String[] values = new String[this.fDetailFormattersMap.size() * 3];
        int i = 0;
        for (DetailFormatter detailFormatter : this.fDetailFormattersMap.values()) {
            values[i++] = detailFormatter.getTypeName();
            values[i++] = detailFormatter.getSnippet().replace(',', '\u0000');
            String string = values[i++] = detailFormatter.isEnabled() ? DETAIL_FORMATTER_IS_ENABLED : DETAIL_FORMATTER_IS_DISABLED;
        }
        String value = DebugOptionsManager.serializeList(values);
        IEclipsePreferences preferences = EclipseUtil.instanceScope().getNode("com.aptana.debug.core");
        preferences.put(this.getDetailFormattersPrefName(), value);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)DebugCorePlugin.getDefault(), (Throwable)e);
        }
    }

    private void notifyChangeListeners() {
        Object[] objectArray = this.changeListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IDetailFormattersChangeListener)listener).detailFormattersChanged();
            ++n2;
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            if (event.getSource() instanceof IDebugTarget && this.modelIdentifier.equals(((IDebugTarget)event.getSource()).getModelIdentifier())) {
                switch (event.getKind()) {
                    case 4: {
                        System.setProperty(String.valueOf(this.modelIdentifier) + DEBUGGER_ACTIVE_SUFFIX, "true");
                        break;
                    }
                    case 8: {
                        System.getProperties().remove(String.valueOf(this.modelIdentifier) + DEBUGGER_ACTIVE_SUFFIX);
                        this.cleanupBreakpoints();
                        break;
                    }
                }
            }
            ++n2;
        }
    }

    private void cleanupBreakpoints() {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] iBreakpointArray = breakpointManager.getBreakpoints(this.modelIdentifier);
        int n = iBreakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            try {
                IResource resource;
                IMarker marker = breakpoint.getMarker();
                URI uri = null;
                uri = marker instanceof IUniformResourceMarker ? ((IUniformResourceMarker)marker).getUniformResource().getURI() : ((resource = marker.getResource()) instanceof IWorkspaceRoot ? URI.create((String)marker.getAttribute("com.aptana.debug.core.breakpointLocation")) : resource.getLocation().makeAbsolute().toFile().toURI());
                if (uri != null && "dbgsource".equals(uri.getScheme())) {
                    breakpoint.delete();
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)DebugCorePlugin.getDefault(), (Throwable)e);
            }
            ++n2;
        }
    }
}

