/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.internal.mpc.ui.CatalogRegistry;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.commands.MarketplaceWizardCommand;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.Operation;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.ui.statushandlers.StatusManager;

public class MarketplaceUrlHandler {
    public static final String DESCRIPTOR_HINT = "org.eclipse.epp.mpc.descriptorHint";
    private static final String UTF_8 = "UTF-8";
    private static final String PARAM_SPLIT_REGEX = "&";
    private static final String EQUALS_REGEX = "=";
    private static final String MPC_STATE = "mpc_state";
    private static final String MPC_INSTALL = "mpc_install";

    public static SolutionInstallationInfo createSolutionInstallInfo(String url) {
        String query;
        try {
            query = new URL(url).getQuery();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        if (query == null) {
            return null;
        }
        String[] params = query.split(PARAM_SPLIT_REGEX);
        String installId = null;
        String state = null;
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            String[] keyValue = param.split(EQUALS_REGEX);
            if (keyValue.length == 2) {
                String key = keyValue[0];
                String value = keyValue[1];
                if (key.equals(MPC_INSTALL)) {
                    installId = value;
                } else if (key.equals(MPC_STATE)) {
                    state = value;
                }
            }
            ++n2;
        }
        if (installId != null) {
            CatalogDescriptor descriptor = CatalogRegistry.getInstance().findCatalogDescriptor(url);
            SolutionInstallationInfo info = new SolutionInstallationInfo();
            info.installId = installId;
            info.state = state;
            if (descriptor != null) {
                info.catalogDescriptor = descriptor;
            } else {
                try {
                    info.catalogDescriptor = new CatalogDescriptor(new URL(url), DESCRIPTOR_HINT);
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
            }
            return info;
        }
        return null;
    }

    public static boolean isPotentialSolution(String url) {
        return url != null && url.contains(MPC_INSTALL);
    }

    public static void triggerInstall(SolutionInstallationInfo info) {
        String installId = info.getInstallId();
        String mpcState = info.getState();
        CatalogDescriptor catalogDescriptor = info.getCatalogDescriptor();
        MarketplaceWizardCommand command = new MarketplaceWizardCommand();
        command.setSelectedCatalogDescriptor(catalogDescriptor);
        try {
            if (mpcState != null) {
                command.setWizardState(URLDecoder.decode(mpcState, UTF_8));
            }
            HashMap<String, Operation> nodeIdToOperation = new HashMap<String, Operation>();
            nodeIdToOperation.put(URLDecoder.decode(installId, UTF_8), Operation.INSTALL);
            command.setOperationByNodeId(nodeIdToOperation);
        }
        catch (UnsupportedEncodingException e1) {
            throw new IllegalStateException(e1);
        }
        try {
            command.execute(new ExecutionEvent());
        }
        catch (ExecutionException e) {
            IStatus status = MarketplaceClientUi.computeStatus(new InvocationTargetException(e), Messages.MarketplaceBrowserIntegration_cannotOpenMarketplaceWizard);
            StatusManager.getManager().handle(status, 7);
        }
    }

    private MarketplaceUrlHandler() {
    }

    public static class SolutionInstallationInfo {
        private String installId;
        private String state;
        private CatalogDescriptor catalogDescriptor;

        public String getInstallId() {
            return this.installId;
        }

        public String getState() {
            return this.state;
        }

        public CatalogDescriptor getCatalogDescriptor() {
            return this.catalogDescriptor;
        }
    }
}

