/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter.nodes;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class NodeTypes {

    public static enum TypeBracket {
        CURLY("{", "}"),
        SQUARE("[", "]"),
        PARENTHESIS("(", ")"),
        ARRAY_CURLY("{", "}"),
        ARRAY_SQUARE("[", "]"),
        ARRAY_PARENTHESIS("(", ")"),
        LOOP_PARENTHESIS("(", ")"),
        CONDITIONAL_PARENTHESIS("(", ")"),
        DECLARATION_PARENTHESIS("(", ")"),
        INVOCATION_PARENTHESIS("(", ")");

        String left;
        String right;

        private TypeBracket(String left, String right) {
            if (left == null || left.length() != 1 || right == null || right.length() != 1) {
                throw new IllegalArgumentException("Cannot create a TypeBracket with " + left + ", " + right);
            }
            this.left = left;
            this.right = right;
        }

        public String getLeft() {
            return this.left;
        }

        public String getRight() {
            return this.right;
        }

        public String toString() {
            return String.valueOf(this.left) + ' ' + this.right;
        }
    }

    public static enum TypeOperator {
        ASSIGNMENT("="),
        DOT_CONCATENATION("."),
        PLUS_CONCATENATION("+"),
        GREATER_THAN(">"),
        LESS_THAN("<"),
        GREATER_THAN_OR_EQUAL(">="),
        LESS_THAN_OR_EQUAL("<="),
        DOT_EQUAL(".="),
        PLUS_EQUAL("+="),
        MINUS_EQUAL("-="),
        MULTIPLY_EQUAL("*="),
        DIVIDE_EQUAL("/="),
        TILDE_EQUAL("~="),
        MULTIPLY("*"),
        PLUS("+"),
        MINUS("-"),
        DIVIDE("/"),
        MODULUS("%"),
        POSTFIX_INCREMENT("++"),
        PREFIX_INCREMENT("++"),
        POSTFIX_DECREMENT("--"),
        PREFIX_DECREMENT("--"),
        OR("||"),
        OR_LITERAL("or"),
        AND("&&"),
        AND_LITERAL("and"),
        XOR("^"),
        XOR_EQUAL("^="),
        XOR_LITERAL("xor"),
        BINARY_OR("|"),
        BINARY_AND("&"),
        OR_EQUAL("|="),
        AND_EQUAL("&="),
        EQUAL("=="),
        SHIFT_RIGHT(">>"),
        SHIFT_LEFT("<<"),
        SHIFT_RIGHT_ASSIGN(">>="),
        SHIFT_LEFT_ASSIGN("<<="),
        SHIFT_RIGHT_ZERO_FILL(">>>"),
        SHIFT_RIGHT_ZERO_FILL_ASSIGN(">>>="),
        IDENTICAL("==="),
        TILDE("~"),
        NOT("!"),
        NOT_EQUAL("!="),
        NOT_EQUAL_ALTERNATE("<>"),
        NOT_IDENTICAL("!=="),
        ARROW("->"),
        STATIC_INVOCATION("::"),
        KEY_VALUE("=>"),
        CONDITIONAL("?"),
        CONDITIONAL_COLON(":"),
        KEY_VALUE_COLON(":"),
        TYPEOF("typeof"),
        IN("in"),
        DELETE("delete"),
        VOID("void"),
        INSTANCOF("instanceof");

        String name;
        private static Map<String, TypeOperator> OPERATORS_MAP;

        static {
            OPERATORS_MAP = new HashMap<String, TypeOperator>();
            for (TypeOperator type : EnumSet.allOf(TypeOperator.class)) {
                OPERATORS_MAP.put(type.toString(), type);
            }
        }

        private TypeOperator(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static TypeOperator getTypeOperator(String operationString) {
            return OPERATORS_MAP.get(operationString.toLowerCase());
        }
    }

    public static enum TypePunctuation {
        CSS_CHILD_COMBINATOR(">"),
        JS_DOT_PROPERTY("."),
        SELECTOR_COLON(":"),
        PROPERTY_COLON(":"),
        CASE_COLON(":"),
        GOTO_COLON(":"),
        SEMICOLON(";"),
        FOR_SEMICOLON(";"),
        COMMA(","),
        ARRAY_COMMA(","),
        NAMESPACE_SEPARATOR("\\");

        String name;

        private TypePunctuation(String name) {
            if (name == null || name.length() != 1) {
                throw new IllegalArgumentException("Cannot create a TypePunctuation with the name: " + name);
            }
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

