/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter.nodes;

import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.IFormatterWriter;
import com.aptana.formatter.nodes.AbstractFormatterNode;
import com.aptana.formatter.nodes.IFormatterTextNode;
import java.io.StringWriter;

public class FormatterTextNode
extends AbstractFormatterNode
implements IFormatterTextNode {
    private final int startOffset;
    private final int endOffset;

    public FormatterTextNode(IFormatterDocument document, int startOffset, int endOffset) {
        super(document);
        if (startOffset > endOffset) {
            throw new IllegalArgumentException("Formatter error: startOffset > endOffset");
        }
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    @Override
    public String getText() {
        return this.getDocument().get(this.startOffset, this.endOffset);
    }

    @Override
    public void accept(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        if (this.shouldConsumePreviousWhiteSpaces() && this.getSpacesCountBefore() > 0) {
            this.writeSpaces(visitor, context, this.getSpacesCountBefore());
        }
        visitor.write(context, this.getStartOffset(), this.getEndOffset());
        if (this.getSpacesCountAfter() > 0) {
            this.writeSpaces(visitor, context, this.getSpacesCountAfter());
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public String toString() {
        StringWriter w = new StringWriter();
        FormatterTextNode.escapeJavaStyleString(w, this.getText());
        return w.toString();
    }

    private static void escapeJavaStyleString(StringWriter out, String str) {
        if (str == null) {
            return;
        }
        int sz = str.length();
        int i = 0;
        while (i < sz) {
            char ch = str.charAt(i);
            if (ch > '\u0fff') {
                out.write("\\u" + FormatterTextNode.hex(ch));
            } else if (ch > '\u00ff') {
                out.write("\\u0" + FormatterTextNode.hex(ch));
            } else if (ch > '\u007f') {
                out.write("\\u00" + FormatterTextNode.hex(ch));
            } else if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        out.write(92);
                        out.write(98);
                        break;
                    }
                    case '\n': {
                        out.write(92);
                        out.write(110);
                        break;
                    }
                    case '\t': {
                        out.write(92);
                        out.write(116);
                        break;
                    }
                    case '\f': {
                        out.write(92);
                        out.write(102);
                        break;
                    }
                    case '\r': {
                        out.write(92);
                        out.write(114);
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            out.write("\\u00" + FormatterTextNode.hex(ch));
                            break;
                        }
                        out.write("\\u000" + FormatterTextNode.hex(ch));
                        break;
                    }
                }
            } else {
                switch (ch) {
                    case '\\': {
                        out.write(92);
                        out.write(92);
                        break;
                    }
                    default: {
                        out.write(ch);
                    }
                }
            }
            ++i;
        }
    }

    private static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase();
    }
}

