/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter.nodes;

import com.aptana.formatter.FormatterUtils;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.nodes.FormatterCommentNode;
import com.aptana.formatter.nodes.FormatterTextNode;
import com.aptana.formatter.nodes.IFormatterCommentableNode;
import com.aptana.formatter.nodes.IFormatterContainerNode;
import com.aptana.formatter.nodes.IFormatterNode;
import com.aptana.formatter.nodes.IFormatterTextNode;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public abstract class FormatterNodeRewriter {
    protected final List<CommentInfo> comments = new ArrayList<CommentInfo>();

    public void rewrite(IFormatterContainerNode root) {
        this.mergeTextNodes(root);
        this.insertComments(root);
    }

    protected void mergeTextNodes(IFormatterContainerNode root) {
        List<IFormatterNode> body = root.getBody();
        ArrayList<IFormatterNode> newBody = new ArrayList<IFormatterNode>();
        ArrayList<IFormatterNode> texts = new ArrayList<IFormatterNode>();
        for (IFormatterNode node : body) {
            if (this.isPlainTextNode(node)) {
                if (!texts.isEmpty() && ((IFormatterTextNode)texts.get(texts.size() - 1)).getEndOffset() != node.getStartOffset()) {
                    this.flushTextNodes(texts, newBody);
                }
                texts.add(node);
                continue;
            }
            if (!texts.isEmpty()) {
                this.flushTextNodes(texts, newBody);
            }
            newBody.add(node);
        }
        if (!texts.isEmpty()) {
            this.flushTextNodes(texts, newBody);
        }
        if (body.size() != newBody.size()) {
            body.clear();
            body.addAll(newBody);
        }
        for (IFormatterNode node : body) {
            if (!(node instanceof IFormatterContainerNode)) continue;
            this.mergeTextNodes((IFormatterContainerNode)node);
        }
    }

    protected void attachComments(IFormatterContainerNode root) {
        ArrayList<IFormatterNode> commentNodes = new ArrayList<IFormatterNode>();
        ArrayList<IFormatterNode> comments = new ArrayList<IFormatterNode>();
        List<IFormatterNode> body = root.getBody();
        for (IFormatterNode node : body) {
            if (node instanceof FormatterCommentNode) {
                comments.add(node);
                continue;
            }
            if (FormatterUtils.isNewLine(node) && !comments.isEmpty() && comments.get(comments.size() - 1) instanceof FormatterCommentNode) {
                comments.add(node);
                continue;
            }
            if (comments.isEmpty()) continue;
            if (node instanceof IFormatterCommentableNode) {
                ((IFormatterCommentableNode)((Object)node)).insertBefore(comments);
                commentNodes.addAll(comments);
            }
            comments.clear();
        }
        body.removeAll(commentNodes);
        for (IFormatterNode node : body) {
            if (!(node instanceof IFormatterContainerNode)) continue;
            this.attachComments((IFormatterContainerNode)node);
        }
    }

    private void flushTextNodes(List<IFormatterNode> texts, List<IFormatterNode> newBody) {
        if (texts.size() > 1) {
            IFormatterNode first = texts.get(0);
            IFormatterNode last = texts.get(texts.size() - 1);
            newBody.add(new FormatterTextNode(first.getDocument(), first.getStartOffset(), last.getEndOffset()));
        } else {
            newBody.addAll(texts);
        }
        texts.clear();
    }

    protected boolean isPlainTextNode(IFormatterNode node) {
        return node.getClass() == FormatterTextNode.class;
    }

    protected void addComment(int startOffset, int endOffset, Object object) {
        this.comments.add(new CommentInfo(startOffset, endOffset, object));
    }

    protected void insertComments(IFormatterContainerNode root) {
        List<IFormatterNode> body = root.getBody();
        ArrayList<IFormatterNode> newBody = new ArrayList<IFormatterNode>();
        boolean changes = false;
        for (IFormatterNode node : body) {
            if (this.isPlainTextNode(node)) {
                if (this.hasComments(node.getStartOffset(), node.getEndOffset())) {
                    this.selectValidRanges(root.getDocument(), node.getStartOffset(), node.getEndOffset(), newBody);
                    changes = true;
                    continue;
                }
                newBody.add(node);
                continue;
            }
            newBody.add(node);
        }
        if (changes) {
            body.clear();
            body.addAll(newBody);
        }
        for (IFormatterNode node : body) {
            if (!(node instanceof IFormatterContainerNode)) continue;
            this.insertComments((IFormatterContainerNode)node);
        }
    }

    private boolean hasComments(int startOffset, int endOffset) {
        for (CommentInfo commentNode : this.comments) {
            if (commentNode.startOffset >= endOffset || startOffset >= commentNode.endOffset) continue;
            return true;
        }
        return false;
    }

    private void selectValidRanges(IFormatterDocument document, int start, int end, List<IFormatterNode> result) {
        for (CommentInfo comment : this.comments) {
            if (start > comment.endOffset || comment.startOffset > end) continue;
            if (start < comment.startOffset) {
                int validEnd = Math.min(end, comment.startOffset);
                String preCommentContent = document.get(start, validEnd);
                Pattern TABS_OR_SPACES = Pattern.compile("\\t| ");
                if (TABS_OR_SPACES.matcher(preCommentContent).replaceAll("").length() > 0) {
                    result.add(new FormatterTextNode(document, start, validEnd));
                } else if (preCommentContent.length() > 0 && !result.isEmpty() && result.get(result.size() - 1).getSpacesCountAfter() == 0) {
                    result.add(new FormatterTextNode(document, validEnd - 1, validEnd));
                }
                start = comment.startOffset;
            }
            result.add(this.createCommentNode(document, start, Math.min(comment.endOffset, end), comment.object));
            start = comment.endOffset;
            if (start > end) break;
        }
        if (start < end) {
            result.add(new FormatterTextNode(document, start, end));
        }
    }

    protected abstract IFormatterNode createCommentNode(IFormatterDocument var1, int var2, int var3, Object var4);

    private static class CommentInfo {
        final int startOffset;
        final int endOffset;
        final Object object;

        public CommentInfo(int startOffset, int endOffset, Object object) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.object = object;
        }
    }
}

