/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter;

import com.aptana.core.logging.IdeLog;
import com.aptana.formatter.IContributedExtension;
import com.aptana.formatter.IContributionSelector;
import com.aptana.formatter.PriorityContributionSelector;
import com.aptana.formatter.epl.FormatterPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;

public abstract class ContributionExtensionManager {
    private static final String CONTENT_TYPE = "contentType";
    private static final String SELECTOR_TAG = "selector";
    private static final String CLASS_TAG = "class";
    private static final String REQUIRED_ACTIVE_BUNDLE = "requiredActiveBundle";
    private IContributionSelector defaultSelector;
    private Map<String, List<IConfigurationElement>> contentTypeToContribMap = new HashMap<String, List<IConfigurationElement>>();
    private Map<String, IConfigurationElement> contentTypeToSelectorMap = new HashMap<String, IConfigurationElement>();
    private Map<IConfigurationElement, String> contribToContentTypeMap = new HashMap<IConfigurationElement, String>();

    protected ContributionExtensionManager() {
        this.defaultSelector = new PriorityContributionSelector();
        this.loadExtensionPoints();
    }

    public IContributedExtension[] getContributions(String contentType) {
        List<IContributedExtension> contributions = this.getContributionsByContentType(contentType);
        return contributions.toArray(new IContributedExtension[contributions.size()]);
    }

    public IContributedExtension[] getAllContributions(boolean forceBundleLoading) {
        Collection<List<IConfigurationElement>> values = this.contentTypeToContribMap.values();
        ArrayList<IContributedExtension> contributions = new ArrayList<IContributedExtension>();
        for (List<IConfigurationElement> contribution : values) {
            contributions.addAll(this.createContributors(contribution, forceBundleLoading));
        }
        return contributions.toArray(new IContributedExtension[contributions.size()]);
    }

    private List<IContributedExtension> createContributors(List<IConfigurationElement> contributions, boolean forceBundleLoading) {
        ArrayList<IContributedExtension> list = new ArrayList<IContributedExtension>();
        for (IConfigurationElement element : contributions) {
            IContributedExtension contrib = this.createContributor(element, forceBundleLoading);
            if (contrib == null) continue;
            list.add(contrib);
        }
        return list;
    }

    private IContributedExtension createContributor(IConfigurationElement element, boolean forceBundleLoading) {
        try {
            IContributedExtension object;
            String requiredBundle = element.getAttribute(REQUIRED_ACTIVE_BUNDLE);
            if ((forceBundleLoading || requiredBundle == null || ContributionExtensionManager.isLoadedBundle(requiredBundle)) && this.isValidContribution(object = (IContributedExtension)element.createExecutableExtension(CLASS_TAG))) {
                IContributedExtension contrib = (IContributedExtension)this.configureContribution(object, element);
                return contrib;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isLoadedBundle(String bundle) {
        Bundle b = Platform.getBundle((String)bundle);
        return b != null && b.getState() == 32;
    }

    public IContributedExtension getSelectedContribution(String contentType) {
        IContributedExtension[] contributions = this.getContributions(contentType);
        if (contributions.length > 0) {
            IContributionSelector selector = this.getSelector(contentType);
            if (selector == null) {
                selector = this.defaultSelector;
            }
            return selector.select(contributions, null);
        }
        return null;
    }

    public IContributedExtension getPriorityContribution(IProject project, String natureId) {
        IContributedExtension[] contributions = this.getContributions(natureId);
        return this.defaultSelector.select(contributions, project);
    }

    protected final List<IContributedExtension> getContributionsByContentType(String contentType) {
        if (!this.hasContributions(contentType)) {
            return Collections.emptyList();
        }
        return this.createContributors(this.contentTypeToContribMap.get(contentType), false);
    }

    protected final IContributionSelector getSelector(String natureId) {
        IConfigurationElement ice = this.contentTypeToSelectorMap.get(natureId);
        if (ice == null) {
            return null;
        }
        try {
            Object object = ice.createExecutableExtension(CLASS_TAG);
            if (object instanceof IContributionSelector) {
                return (IContributionSelector)object;
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)FormatterPlugin.getDefault(), (Throwable)e, (String)"com.aptana.formatter.epl/debug");
        }
        return null;
    }

    protected final boolean hasContributions(String contentType) {
        if (this.contentTypeToContribMap.containsKey(contentType)) {
            List<IConfigurationElement> list = this.contentTypeToContribMap.get(contentType);
            return !list.isEmpty();
        }
        return false;
    }

    public final boolean hasSelector(String contentType) {
        return this.contentTypeToSelectorMap.containsKey(contentType);
    }

    public final IContributedExtension getContributionById(String id) {
        Iterator<String> keys = this.contentTypeToContribMap.keySet().iterator();
        while (keys.hasNext()) {
            List<IConfigurationElement> list = this.contentTypeToContribMap.get(keys.next());
            for (IConfigurationElement contrib : list) {
                if (!contrib.getAttribute("id").equals(id)) continue;
                return this.createContributor(contrib, false);
            }
        }
        return null;
    }

    protected String getContentTypeByContribution(IContributedExtension contribution) {
        for (IConfigurationElement ice : this.contribToContentTypeMap.keySet()) {
            String className = ice.getAttribute(CLASS_TAG);
            if (!className.equals(contribution.getClass().getName())) continue;
            return this.contribToContentTypeMap.get(ice);
        }
        return null;
    }

    protected abstract String getContributionElementName();

    protected abstract String getExtensionPoint();

    protected abstract boolean isValidContribution(Object var1);

    protected Object configureContribution(Object object, IConfigurationElement config) {
        return object;
    }

    protected final void addContribution(String contentType, IConfigurationElement element) {
        List<IConfigurationElement> list = this.contentTypeToContribMap.get(contentType);
        if (list == null) {
            list = new ArrayList<IConfigurationElement>();
        }
        list.add(element);
        this.contentTypeToContribMap.put(contentType, list);
        this.contribToContentTypeMap.put(element, contentType);
    }

    protected final void addSelector(String natureId, IConfigurationElement element) {
        this.contentTypeToSelectorMap.put(natureId, element);
    }

    private void loadChildren(String contentType, IConfigurationElement[] innerElements) {
        IConfigurationElement[] iConfigurationElementArray = innerElements;
        int n = innerElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement innerElement = iConfigurationElementArray[n2];
            String name = innerElement.getName();
            if (name.equals(this.getContributionElementName())) {
                this.addContribution(contentType, innerElement);
            } else if (name.equals(SELECTOR_TAG)) {
                this.addSelector(contentType, innerElement);
            }
            ++n2;
        }
    }

    private void loadExtensionPoints() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] extensions = registry.getExtensionPoint(this.getExtensionPoint()).getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements;
            IExtension extension = extensions[i];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement main = iConfigurationElementArray[n2];
                if (this.isContentTypeContribution(main)) {
                    String natureId = main.getAttribute(CONTENT_TYPE);
                    IConfigurationElement[] innerElements = main.getChildren();
                    this.loadChildren(natureId, innerElements);
                }
                ++n2;
            }
            ++i;
        }
    }

    protected boolean isContentTypeContribution(IConfigurationElement main) {
        return true;
    }
}

