/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter;

import com.aptana.core.logging.IdeLog;
import com.aptana.formatter.ContributedExtension;
import com.aptana.formatter.IScriptFormatterFactory;
import com.aptana.formatter.ScriptFormatterManager;
import com.aptana.formatter.epl.FormatterPlugin;
import com.aptana.formatter.preferences.IPreferencesSaveDelegate;
import com.aptana.formatter.preferences.PreferenceKey;
import com.aptana.formatter.preferences.PreferencesLookupDelegate;
import com.aptana.formatter.preferences.profile.IProfile;
import com.aptana.formatter.preferences.profile.ProfileManager;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public abstract class AbstractScriptFormatterFactory
extends ContributedExtension
implements IScriptFormatterFactory {
    private static final String USE_GLOBAL_DEFAULTS_KEY = "com.aptana.editor.common.useGlobalDefaults";
    private String mainContentType;

    @Override
    public String getMainContentType() {
        if (this.mainContentType == null) {
            this.mainContentType = ScriptFormatterManager.getContentTypeByFactory(this);
        }
        return this.mainContentType;
    }

    @Override
    public void setMainContentType(String mainContentType) {
        this.mainContentType = mainContentType;
    }

    @Override
    public Map<String, String> retrievePreferences(PreferencesLookupDelegate delegate) {
        ProfileManager profileManager = ProfileManager.getInstance();
        PreferenceKey activeProfileKey = profileManager.getActiveProfileKey();
        if (activeProfileKey != null) {
            String profileId = delegate.getString(activeProfileKey.getQualifier(), activeProfileKey.getName());
            if (profileId != null && profileId.length() != 0) {
                for (IProfile profile : profileManager.getBuiltInProfiles()) {
                    if (!profileId.equals(profile.getID())) continue;
                    return profile.getSettings();
                }
                for (IProfile profile : profileManager.getCustomProfiles()) {
                    if (!profileId.equals(profile.getID())) continue;
                    return profile.getSettings();
                }
            } else {
                List<IProfile> builtInProfiles = profileManager.getBuiltInProfiles();
                if (builtInProfiles != null && !builtInProfiles.isEmpty()) {
                    return builtInProfiles.get(0).getSettings();
                }
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        PreferenceKey[] keys = this.getPreferenceKeys();
        if (keys != null) {
            PreferenceKey[] preferenceKeyArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                PreferenceKey prefKey = preferenceKeyArray[n2];
                String key = prefKey.getName();
                result.put(key, delegate.getString(prefKey.getQualifier(), key));
                ++n2;
            }
        }
        return result;
    }

    @Override
    public void savePreferences(Map<String, String> preferences, IPreferencesSaveDelegate delegate) {
        this.savePreferences(preferences, delegate, false);
    }

    @Override
    public void savePreferences(Map<String, String> preferences, IPreferencesSaveDelegate delegate, boolean isInitializing) {
        this.updateEditorTabSize(preferences, isInitializing);
        PreferenceKey[] keys = this.getPreferenceKeys();
        if (keys != null) {
            PreferenceKey[] preferenceKeyArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                PreferenceKey prefKey = preferenceKeyArray[n2];
                String key = prefKey.getName();
                if (preferences.containsKey(key)) {
                    String value = preferences.get(key);
                    delegate.setString(prefKey.getQualifier(), key, value);
                }
                ++n2;
            }
        }
    }

    protected void updateEditorTabSize(Map<String, String> preferences, boolean isInitializing) {
        IEclipsePreferences prefs = this.getEclipsePreferences();
        int editorTabSize = this.getEditorTabSize();
        if ("editor".equals(this.getFormatterTabPolicy(preferences))) {
            preferences.put(this.getFormatterTabSizeKey(), String.valueOf(editorTabSize));
        } else {
            int selectedTabValue;
            String prefTabSize = preferences.get(this.getFormatterTabSizeKey());
            int n = selectedTabValue = prefTabSize != null ? Integer.parseInt(prefTabSize) : 0;
            if (selectedTabValue == editorTabSize) {
                if (selectedTabValue == this.getDefaultEditorTabSize()) {
                    prefs.remove("tabWidth");
                    prefs.putBoolean(USE_GLOBAL_DEFAULTS_KEY, true);
                }
            } else {
                if (isInitializing) {
                    selectedTabValue = editorTabSize;
                    preferences.put(this.getFormatterTabSizeKey(), String.valueOf(selectedTabValue));
                }
                prefs.putInt("tabWidth", selectedTabValue);
                prefs.putBoolean(USE_GLOBAL_DEFAULTS_KEY, selectedTabValue == this.getDefaultEditorTabSize());
            }
            try {
                prefs.flush();
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)FormatterPlugin.getDefault(), (Throwable)e);
            }
        }
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public URL getPreviewContent() {
        return null;
    }

    @Override
    public boolean isContributingToUI() {
        return true;
    }

    @Override
    public boolean canConsumePreviousIndent() {
        return true;
    }

    @Override
    public void updateProfile(IProfile profile) {
        int tabSize = this.getEditorTabSize();
        Map<String, String> settings = profile.getSettings();
        settings.put(this.getFormatterTabSizeKey(), Integer.toString(tabSize));
        profile.setSettings(settings);
    }

    protected abstract String getFormatterTabSizeKey();

    protected abstract int getEditorTabSize();

    protected abstract int getDefaultEditorTabSize();

    protected abstract IEclipsePreferences getEclipsePreferences();

    protected abstract String getFormatterTabPolicy(Map<String, String> var1);
}

