/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ConnectionReaper;
import com.aptana.core.util.IObjectPool;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.runtime.Plugin;

public abstract class ReapingObjectPool<T>
implements IObjectPool<T> {
    private long expirationTime;
    private Hashtable<T, Long> locked;
    private Hashtable<T, Long> unlocked;
    private ConnectionReaper reaper;
    private int poolsize = 10;

    public ReapingObjectPool() {
        this(30000);
    }

    public ReapingObjectPool(int expirationTime) {
        this.expirationTime = expirationTime;
        this.locked = new Hashtable(this.poolsize);
        this.unlocked = new Hashtable(this.poolsize);
        if (expirationTime != -1) {
            this.reaper = new ConnectionReaper(this);
        }
    }

    protected void start() {
        if (this.reaper != null) {
            this.reaper.start();
        }
    }

    public synchronized void reap() {
        long now = System.currentTimeMillis();
        Enumeration<T> e = this.unlocked.keys();
        while (e != null && e.hasMoreElements()) {
            T t = e.nextElement();
            if (this.expirationTime == -1L || now - this.unlocked.get(t) <= this.expirationTime || this.validate(t)) continue;
            this.unlocked.remove(t);
            this.expire(t);
            t = null;
        }
    }

    @Override
    public synchronized void dispose() {
        Enumeration<T> e = this.unlocked.keys();
        while (e != null && e.hasMoreElements()) {
            T t = e.nextElement();
            this.unlocked.remove(t);
            this.expire(t);
        }
        if (this.locked != null && this.locked.size() > 0) {
            IdeLog.logWarning((Plugin)CorePlugin.getDefault(), MessageFormat.format("Killed a connection pool that still has {0} locked items", this.locked.size()));
        }
        try {
            this.reaper.keepRunning = false;
            this.reaper.interrupt();
        }
        catch (Exception exception) {}
    }

    @Override
    public abstract void expire(T var1);

    @Override
    public abstract T create();

    @Override
    public abstract boolean validate(T var1);

    @Override
    public synchronized T checkOut() {
        long now = System.currentTimeMillis();
        Iterator<T> iterator = this.unlocked.keySet().iterator();
        if (iterator.hasNext()) {
            T c = iterator.next();
            this.unlocked.remove(c);
            this.locked.put(c, now);
            return c;
        }
        T c = this.create();
        this.locked.put(c, now);
        return c;
    }

    @Override
    public synchronized void checkIn(T t) {
        this.locked.remove(t);
        this.unlocked.put(t, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int unlockedItems() {
        Hashtable<T, Long> hashtable = this.unlocked;
        synchronized (hashtable) {
            return this.unlocked.size();
        }
    }
}

