/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ProgressMonitorInterrupter {
    private static final int CHECK_INTERVAL = 1000;
    private final IProgressMonitor monitor;
    private final Thread thread;
    private final MonitorThread monitorThread;
    private static Map<Thread, InterruptDelegate> delegates = Collections.synchronizedMap(new WeakHashMap());

    public ProgressMonitorInterrupter(IProgressMonitor monitor) {
        this.monitor = monitor != null ? monitor : new NullProgressMonitor();
        this.thread = Thread.currentThread();
        this.monitorThread = new MonitorThread();
        this.monitorThread.start();
    }

    public void dispose() {
        this.monitorThread.interrupt();
    }

    public static void setCurrentThreadInterruptDelegate(InterruptDelegate delegate) {
        if (delegate != null) {
            delegates.put(Thread.currentThread(), delegate);
        } else {
            delegates.remove(Thread.currentThread());
        }
    }

    private static void interruptThread(Thread thread) {
        InterruptDelegate delegate = delegates.get(thread);
        if (delegate != null) {
            delegate.interrupt();
        } else {
            thread.interrupt();
        }
    }

    public static interface InterruptDelegate {
        public void interrupt();
    }

    private class MonitorThread
    extends Thread {
        public MonitorThread() {
            super("Progress Monitor Thread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (!MonitorThread.interrupted()) {
                    if (ProgressMonitorInterrupter.this.monitor.isCanceled()) {
                        ProgressMonitorInterrupter.interruptThread(ProgressMonitorInterrupter.this.thread);
                        break;
                    }
                    MonitorThread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

