/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.util.IObjectPool;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class ObjectPool<T>
implements IObjectPool<T> {
    private static final int DEFAULT_EXPIRATION = 30000;
    private long expirationTime;
    private Hashtable<T, Long> locked;
    private Hashtable<T, Long> unlocked;

    public ObjectPool(int expirationTime) {
        this.expirationTime = expirationTime;
        this.locked = new Hashtable();
        this.unlocked = new Hashtable();
    }

    public ObjectPool() {
        this(30000);
    }

    @Override
    public abstract T create();

    @Override
    public abstract boolean validate(T var1);

    @Override
    public abstract void expire(T var1);

    @Override
    public synchronized T checkOut() {
        T t;
        long now = System.currentTimeMillis();
        if (this.unlocked.size() > 0) {
            Enumeration<T> e = this.unlocked.keys();
            while (e.hasMoreElements()) {
                t = e.nextElement();
                if (this.expirationTime != -1L && now - this.unlocked.get(t) > this.expirationTime) {
                    this.unlocked.remove(t);
                    this.expire(t);
                    t = null;
                    continue;
                }
                if (this.validate(t)) {
                    this.unlocked.remove(t);
                    this.locked.put(t, now);
                    return t;
                }
                this.unlocked.remove(t);
                this.expire(t);
                t = null;
            }
        }
        if ((t = this.create()) != null) {
            this.locked.put(t, now);
        }
        return t;
    }

    @Override
    public synchronized void checkIn(T t) {
        this.locked.remove(t);
        this.unlocked.put(t, System.currentTimeMillis());
    }

    @Override
    public synchronized void dispose() {
        for (T t : this.unlocked.keySet()) {
            this.expire(t);
        }
        this.unlocked.clear();
    }
}

