/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ProcessUtil;
import com.aptana.core.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class JVMInfo {
    private static final String PROGRAM_FILES_X86_ENV = "ProgramFiles(x86)";
    private static final String PROGRAM_W6432_ENV = "ProgramW6432";
    private static final String PROGRAM_FILES_ENV = "ProgramFiles";
    private static final String JAVAC = "javac";
    private static final String VERSION_CMD = "-version";
    private static final String JAVA_6_SPECIFICATION = "1.6";
    protected boolean isJDKInstalled;
    protected boolean is32bit;
    protected String javaVersion;
    protected String javaHome;
    private String detectedJavaHome;
    protected int javaUpdateVersion;
    protected IPath javacPath;
    private static JVMInfo instance;

    public static synchronized JVMInfo getInstance() {
        if (instance == null) {
            instance = new JVMInfo();
        }
        return instance;
    }

    public static synchronized void reset() {
        instance = null;
    }

    private JVMInfo() {
        this.load();
    }

    public boolean isJavaHomeSet() {
        return !StringUtil.isEmpty(this.javaHome);
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public boolean is32bit() {
        return this.is32bit;
    }

    public boolean isJava6() {
        return JAVA_6_SPECIFICATION.equals(this.getJavaVersion());
    }

    public boolean isJDKInstalled() {
        return this.isJDKInstalled;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public int getJavaUpdateVersion() {
        return this.javaUpdateVersion;
    }

    private void load() {
        try {
            this.parseJavaVersion();
            this.resolveJavaHome();
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), e);
        }
    }

    private void resolveJavaHome() {
        Map<String, String> env = System.getenv();
        String javaHome = env.get("JAVA_HOME");
        if (JVMInfo.isValidJavaHome(javaHome)) {
            this.javaHome = javaHome;
        } else if (!StringUtil.isEmpty(this.detectedJavaHome)) {
            this.javaHome = this.detectedJavaHome;
        } else {
            IPath path;
            javaHome = System.getProperty("java.home");
            if (!StringUtil.isEmpty(javaHome) && (path = Path.fromOSString((String)javaHome)).lastSegment().startsWith("jre")) {
                javaHome = path.removeLastSegments(1).toString();
            }
            if (JVMInfo.isValidJavaHome(javaHome)) {
                this.javaHome = javaHome;
            }
        }
    }

    private static boolean isValidJavaHome(String directory) {
        File file;
        if (!StringUtil.isEmpty(directory) && (file = new File(directory)).isDirectory()) {
            File toolsJar = new File(file, "lib/tools.jar");
            File dtJar = new File(file, "lib/dt.jar");
            return toolsJar.exists() || dtJar.exists();
        }
        return false;
    }

    private void parseJavaVersion() {
        Matcher matcher;
        String arch;
        String updateString;
        Matcher matcher2;
        int updateSeparator;
        String specificationVersion = System.getProperty("java.specification.version");
        if (specificationVersion != null) {
            this.javaVersion = specificationVersion;
        }
        String fullVersion = System.getProperty("java.version");
        Pattern numberPattern = Pattern.compile("\\d+");
        if (fullVersion != null && (updateSeparator = fullVersion.indexOf(95)) > -1 && (matcher2 = numberPattern.matcher(updateString = fullVersion.substring(updateSeparator + 1))).find()) {
            try {
                this.javaUpdateVersion = Integer.parseInt(updateString.substring(matcher2.start(), matcher2.end()));
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CorePlugin.getDefault(), MessageFormat.format("Could not parse the JVM update version for ''{0}''", updateString), e);
            }
        }
        if ((arch = System.getProperty("sun.arch.data.model")) == null) {
            arch = Platform.getOSArch();
        }
        if (arch != null && (matcher = numberPattern.matcher(arch)).find()) {
            try {
                this.is32bit = Integer.parseInt(arch.substring(matcher.start(), matcher.end())) != 64;
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CorePlugin.getDefault(), MessageFormat.format("Could not parse the OS architecture version for ''{0}''", arch), e);
            }
        }
        String javacFile = "win32".equals(Platform.getOS()) ? "javac.exe" : JAVAC;
        this.isJDKInstalled = this.hasJavac(javacFile);
        Path javaPath = null;
        IPath javacPath = null;
        if (!this.isJDKInstalled) {
            javaPath = new Path("Java");
            javacPath = new Path("bin").append(javacFile);
            String env = System.getenv(PROGRAM_FILES_ENV);
            boolean bl = this.isJDKInstalled = env == null ? this.hasJavac64((IPath)javaPath, javacPath) : this.hasJavac6432((IPath)javaPath, javacPath);
            if (!this.isJDKInstalled) {
                this.isJDKInstalled = this.hasJavac64((IPath)javaPath, javacPath);
            }
            if (!this.isJDKInstalled) {
                this.isJDKInstalled = this.hasJavac32((IPath)javaPath, javacPath);
            }
        }
    }

    private boolean hasJavac6432(IPath javaPath, IPath javacPath) {
        String env6432 = System.getenv(PROGRAM_W6432_ENV);
        if (env6432 != null) {
            return this.hasJavac(Path.fromOSString((String)env6432).append(javaPath).toFile().listFiles(), javacPath);
        }
        return false;
    }

    private boolean hasJavac64(IPath javaPath, IPath javacPath) {
        String env64 = System.getenv(PROGRAM_W6432_ENV);
        if (env64 == null || env64.equals(System.getenv(PROGRAM_FILES_ENV))) {
            return this.hasJavac32(javaPath, javacPath);
        }
        return this.hasJavac(Path.fromOSString((String)env64).append(javaPath).toFile().listFiles(), javacPath);
    }

    private boolean hasJavac32(IPath javaPath, IPath javacPath) {
        String env32 = System.getenv(PROGRAM_FILES_X86_ENV);
        if (env32 == null) {
            return false;
        }
        return this.hasJavac(Path.fromOSString((String)env32).append(javaPath).toFile().listFiles(), javacPath);
    }

    private boolean hasJavac(File[] folders, IPath javacPath) {
        if (folders != null) {
            File[] fileArray = folders;
            int n = folders.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory() && this.hasJavac(Path.fromOSString((String)f.getAbsolutePath()).append(javacPath).toString())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean hasJavac(String javacPath) {
        block8: {
            if (!javacPath.startsWith(JAVAC) && !new File(javacPath).exists()) {
                return false;
            }
            ProcessBuilder pb = new ProcessBuilder(javacPath, VERSION_CMD);
            pb.redirectErrorStream(true);
            try {
                Process process = pb.start();
                String output = ProcessUtil.outputForProcess(process);
                if (!output.startsWith(JAVAC)) break block8;
                IPath javac = Path.fromOSString((String)javacPath).removeLastSegments(1);
                if ("win32".equals(Platform.getOS()) && javac.segmentCount() == 0) {
                    try {
                        pb = new ProcessBuilder("where", JAVAC);
                        pb.redirectErrorStream(true);
                        process = pb.start();
                        output = ProcessUtil.outputForProcess(process);
                        if (!StringUtil.isEmpty(output) && new File(output).exists()) {
                            javac = Path.fromOSString((String)output).removeLastSegments(1);
                        }
                    }
                    catch (IOException e) {
                        IdeLog.logWarning((Plugin)CorePlugin.getDefault(), "Failed to detect the Java Home by calling 'where' on the 'javac'", e);
                    }
                }
                if ("bin".equals(javac.lastSegment()) && JVMInfo.isValidJavaHome((javac = javac.removeLastSegments(1)).toString())) {
                    this.detectedJavaHome = javac.toString();
                }
                return true;
            }
            catch (IOException e) {
                IdeLog.logWarning((Plugin)CorePlugin.getDefault(), "Failed detecting a JDK installation on the system", e);
            }
        }
        return false;
    }

    public IPath getJavacPath() {
        return this.javacPath;
    }
}

