/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.StringUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class EclipseUtil {
    public static final String STANDALONE_PLUGIN_ID = "com.aptana.rcp";
    private static final String[] UNIT_TEST_IDS = new String[]{"org.eclipse.pde.junit.runtime.uitestapplication", "org.eclipse.test.coretestapplication", "org.eclipse.test.uitestapplication", "org.eclipse.pde.junit.runtime.legacytestapplication", "org.eclipse.pde.junit.runtime.coretestapplication", "org.eclipse.pde.junit.runtime.coretestapplicationnonmain", "org.eclipse.pde.junit.runtime.nonuithreadtestapplication"};
    static final String[] LAUNCHER_NAMES = new String[]{"Eclipse", "AptanaStudio3", "Aptana Studio 3", "TitaniumStudio", "Titanium Studio"};
    private static Boolean isTesting;
    private static String rcpPluginId;
    private static String versionPluginId;

    static {
        rcpPluginId = STANDALONE_PLUGIN_ID;
        versionPluginId = "com.aptana.branding";
    }

    private EclipseUtil() {
    }

    public static boolean isDebugOptionEnabled(String option) {
        return Boolean.valueOf(Platform.getDebugOption((String)option));
    }

    public static boolean isSystemPropertyEnabled(String option) {
        return EclipseUtil.getSystemProperty(option) != null;
    }

    public static String getSystemProperty(String option) {
        if (option == null) {
            return null;
        }
        return System.getProperty(option);
    }

    public static boolean isPluginLoaded(Plugin plugin) {
        return plugin != null && plugin.getBundle() != null;
    }

    public static String getPluginVersion(Plugin plugin) {
        if (!EclipseUtil.isPluginLoaded(plugin)) {
            return null;
        }
        return ((String)plugin.getBundle().getHeaders().get("Bundle-Version")).toString();
    }

    public static String getPluginVersion(String pluginId) {
        if (pluginId == null) {
            return null;
        }
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            return null;
        }
        return ((String)bundle.getHeaders().get("Bundle-Version")).toString();
    }

    public static String getProductVersion() {
        String version = null;
        try {
            IProduct product = Platform.getProduct();
            String aboutText = product.getProperty("aboutText");
            String pattern = "Version: (.*)\n";
            Pattern p = Pattern.compile(pattern);
            Matcher m = p.matcher(aboutText);
            boolean found = m.find();
            if (!found) {
                p = Pattern.compile("build: (.*)\n");
                m = p.matcher(aboutText);
                found = m.find();
            }
            if (found) {
                version = m.group(1);
            }
        }
        catch (Exception exception) {}
        return version;
    }

    public static String getStudioVersion() {
        Bundle bundle = Platform.getBundle((String)versionPluginId);
        if (bundle != null) {
            return bundle.getVersion().toString();
        }
        return EclipseUtil.getProductVersion();
    }

    public static boolean isStandalone() {
        return EclipseUtil.getPluginVersion(rcpPluginId) != null;
    }

    public static boolean isTesting() {
        Object commands;
        if (isTesting != null) {
            return isTesting;
        }
        String application = System.getProperty("eclipse.application");
        if (application != null) {
            String[] stringArray = UNIT_TEST_IDS;
            int n = UNIT_TEST_IDS.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if (id.equals(application)) {
                    isTesting = Boolean.TRUE;
                    return isTesting;
                }
                ++n2;
            }
        }
        isTesting = (commands = System.getProperties().get("eclipse.commands")) != null ? commands.toString().contains("-testLoaderClass") : false;
        return isTesting;
    }

    public static IPath getApplicationLauncher() {
        return EclipseUtil.getApplicationLauncher(false);
    }

    public static IPath getApplicationLauncher(boolean asSplashLauncher) {
        String[] executableFiles;
        Location location;
        Path launcher = null;
        String cmdline = System.getProperty("eclipse.commands");
        if (cmdline != null && cmdline.length() > 0) {
            String[] args = cmdline.split("\n");
            int i = 0;
            while (i < args.length) {
                if ("-launcher".equals(args[i]) && i + 1 < args.length) {
                    launcher = Path.fromOSString((String)args[i + 1]);
                    break;
                }
                ++i;
            }
        }
        if (launcher == null && (location = Platform.getInstallLocation()) != null && (launcher = new Path(location.getURL().getFile())).toFile().isDirectory() && (executableFiles = launcher.toFile().list(new LauncherFilter())).length > 0) {
            launcher = launcher.append(executableFiles[0]);
        }
        if (launcher == null || !launcher.toFile().exists()) {
            return null;
        }
        if ("macosx".equals(Platform.getOS()) && asSplashLauncher) {
            launcher = new Path(PlatformUtil.getApplicationExecutable(launcher.toOSString()).getAbsolutePath());
        }
        return launcher;
    }

    public static void setRCPPluginId(String pluginId) {
        if (!StringUtil.isEmpty(pluginId)) {
            rcpPluginId = pluginId;
        }
    }

    public static void setVersionPluginId(String pluginId) {
        if (!StringUtil.isEmpty(pluginId)) {
            versionPluginId = pluginId;
        }
    }

    public static boolean showSystemJobs() {
        if (Platform.inDebugMode()) {
            return true;
        }
        return Platform.getPreferencesService().getBoolean("com.aptana.core", "show_system_jobs", false, null);
    }

    public static void setSystemForJob(Job job) {
        try {
            job.setSystem(!EclipseUtil.showSystemJobs());
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public static void setPlatformDebugging(boolean debugEnabled) {
        if (debugEnabled) {
            FrameworkProperties.setProperty((String)"osgi.debug", (String)"true");
        } else {
            FrameworkProperties.clearProperty((String)"osgi.debug");
        }
    }

    public static Map<String, String> getTraceableItems() {
        Bundle[] bundles;
        HashMap<String, String> stringModels = new HashMap<String, String>();
        BundleContext context = CorePlugin.getDefault().getContext();
        Bundle[] bundleArray = bundles = context.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            Properties props = EclipseUtil.getTraceOptions(bundle);
            for (Object obj : props.keySet()) {
                String key = obj.toString();
                stringModels.put(key, props.getProperty(key));
            }
            ++n2;
        }
        return stringModels;
    }

    public static Properties getTraceOptions(Bundle bundle) {
        Path path = new Path(".options");
        URL fileURL = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (fileURL != null) {
            try {
                InputStream in = fileURL.openStream();
                Properties options = new Properties();
                options.load(in);
                return options;
            }
            catch (IOException iOException) {}
        }
        return new Properties();
    }

    public static Map<String, BundleContext> getCurrentBundleContexts() {
        Bundle[] bundles;
        HashMap<String, BundleContext> contexts = new HashMap<String, BundleContext>();
        BundleContext context = CorePlugin.getDefault().getContext();
        contexts.put(context.getBundle().getSymbolicName(), context);
        Bundle[] bundleArray = bundles = context.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            BundleContext bContext = bundle.getBundleContext();
            if (bContext != null) {
                contexts.put(bundle.getSymbolicName(), bContext);
            }
            ++n2;
        }
        return contexts;
    }

    public static void setBundleDebugOptions(String[] currentOptions, boolean debugEnabled) {
        Map<String, BundleContext> bundles = EclipseUtil.getCurrentBundleContexts();
        String[] stringArray = currentOptions;
        int n = currentOptions.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String symbolicName = key.substring(0, key.indexOf(47));
            BundleContext bundleContext = bundles.get(symbolicName);
            if (bundleContext != null) {
                ServiceReference sRef = bundleContext.getServiceReference(DebugOptions.class.getName());
                DebugOptions options = (DebugOptions)bundleContext.getService(sRef);
                if (debugEnabled) {
                    options.setDebugEnabled(debugEnabled);
                    options.setOption(key, Boolean.toString(debugEnabled));
                } else {
                    options.setOption(key, Boolean.toString(debugEnabled));
                    options.setDebugEnabled(debugEnabled);
                }
            }
            ++n2;
        }
    }

    public static String[] getCurrentDebuggableComponents() {
        String checked = Platform.getPreferencesService().getString("com.aptana.core", "pref_debug_component_list", null, null);
        if (checked != null) {
            return checked.split(",");
        }
        return ArrayUtil.NO_STRINGS;
    }

    public static void processConfigurationElements(String pluginId, String extensionPointId, IConfigurationElementProcessor processor) {
        IExtensionPoint extensionPoint;
        IExtensionRegistry registry;
        if (!(StringUtil.isEmpty(pluginId) || StringUtil.isEmpty(extensionPointId) || processor == null || processor.getSupportElementNames().isEmpty() || (registry = Platform.getExtensionRegistry()) == null || (extensionPoint = registry.getExtensionPoint(pluginId, extensionPointId)) == null)) {
            Set<String> elementNames = processor.getSupportElementNames();
            IExtension[] extensions = extensionPoint.getExtensions();
            for (String elementName : elementNames) {
                IExtension[] iExtensionArray = extensions;
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement[] elements;
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                    int n3 = elements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement element = iConfigurationElementArray[n4];
                        if (element.getName().equals(elementName)) {
                            processor.processElement(element);
                            if (IdeLog.isTraceEnabled(CorePlugin.getDefault(), "com.aptana.core/debug/extension_points")) {
                                IdeLog.logTrace(CorePlugin.getDefault(), MessageFormat.format("Processing extension element {0} with attributes {1}", element.getName(), EclipseUtil.collectElementAttributes(element)), "com.aptana.core/debug/extension_points");
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
    }

    public static Map<String, String> collectElementAttributes(IConfigurationElement element) {
        String[] attributes;
        TreeMap<String, String> map = new TreeMap<String, String>();
        String[] stringArray = attributes = element.getAttributeNames();
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            map.put(string, element.getAttribute(string));
            ++n2;
        }
        return map;
    }

    public static InstanceScope instanceScope() {
        return new InstanceScope();
    }

    public static DefaultScope defaultScope() {
        return new DefaultScope();
    }

    public static ConfigurationScope configurationScope() {
        return new ConfigurationScope();
    }

    protected static final class LauncherFilter
    implements FilenameFilter {
        protected LauncherFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            IPath path = Path.fromOSString((String)dir.getAbsolutePath()).append(name);
            name = path.removeFileExtension().lastSegment();
            String ext = path.getFileExtension();
            if ("macosx".equals(Platform.getOS()) && !"app".equals(ext)) {
                return false;
            }
            String[] stringArray = LAUNCHER_NAMES;
            int n = LAUNCHER_NAMES.length;
            int n2 = 0;
            while (n2 < n) {
                String launcherName = stringArray[n2];
                if (launcherName.equalsIgnoreCase(name)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

