/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.GetPropertor;
import com.aptana.core.IFilter;
import com.aptana.core.IMap;
import com.aptana.core.util.IInjectBlock;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionsUtil {
    public static final <T, U extends T> List<T> addToList(List<T> list, U ... items) {
        return com.pandora.core.utils.CollectionsUtil.addToList(list, (Object[])items);
    }

    public static final <T, U extends T> Set<T> addToSet(Set<T> set, U ... items) {
        return com.pandora.core.utils.CollectionsUtil.addToSet(set, (Object[])items);
    }

    public static <T> void filter(Collection<T> source, Collection<T> destination, IFilter<? super T> filter) {
        if (source != null && destination != null) {
            if (filter != null) {
                for (T item : source) {
                    if (!filter.include(item)) continue;
                    destination.add(item);
                }
            } else {
                destination.addAll(source);
            }
            if (destination instanceof ArrayList) {
                ((ArrayList)destination).trimToSize();
            }
        }
    }

    public static <T> T find(Collection<T> collection, IFilter<T> filter) {
        if (collection != null && filter != null) {
            for (T item : collection) {
                if (!filter.include(item)) continue;
                return item;
            }
        }
        return null;
    }

    public static <T> List<T> filter(Collection<T> collection, IFilter<T> filter) {
        ArrayList result = new ArrayList(collection == null ? 0 : collection.size());
        CollectionsUtil.filter(collection, result, filter);
        return result;
    }

    public static <T> void filterInPlace(Collection<T> collection, IFilter<? super T> filter) {
        if (collection != null && filter != null) {
            Iterator<T> iterator = collection.iterator();
            while (iterator.hasNext()) {
                T item = iterator.next();
                if (filter.include(item)) continue;
                iterator.remove();
            }
        }
    }

    public static <T> List<T> getListValue(List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public static <T, E> Set<T> getPropertyList(Collection<E> list, GetPropertor<E, T> getPropertor) {
        HashSet<T> results = new HashSet<T>();
        if (list == null) {
            return Collections.emptySet();
        }
        for (E e : list) {
            results.add(getPropertor.getProperty(e));
        }
        return results;
    }

    public static <T, U> Map<T, U> getMapValue(Map<T, U> list) {
        return com.pandora.core.utils.CollectionsUtil.getMapValue(list);
    }

    public static <T> Set<T> getSetValue(Set<T> set) {
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    public static <T> Collection<T> getNonOverlapping(Collection<T> collection1, Collection<T> collection2) {
        Collection<T> result = CollectionsUtil.union(collection1, collection2);
        if (!CollectionsUtil.isEmpty(result)) {
            result.removeAll(CollectionsUtil.intersect(collection1, collection2));
            if (result instanceof ArrayList) {
                ((ArrayList)result).trimToSize();
            }
        }
        return result;
    }

    public static <T> Collection<T> intersect(Collection<T> collection1, Collection<T> collection2) {
        if (CollectionsUtil.isEmpty(collection1) || CollectionsUtil.isEmpty(collection2)) {
            return Collections.emptyList();
        }
        HashSet<T> intersection = new HashSet<T>(collection1);
        intersection.retainAll(collection2);
        return intersection;
    }

    public static <T> boolean isEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T, U> boolean isEmpty(Map<T, U> map) {
        return map == null || map.isEmpty();
    }

    public static <T, U> boolean isNotEmpty(Map<T, U> map) {
        return !CollectionsUtil.isEmpty(map);
    }

    public static <T, U> void map(Collection<T> source, Collection<U> destination, IMap<? super T, U> mapper) {
        if (source != null && destination != null && mapper != null) {
            for (T item : source) {
                U value = mapper.map(item);
                if (value == null) continue;
                destination.add(value);
            }
            if (destination instanceof ArrayList) {
                ((ArrayList)destination).trimToSize();
            }
        }
    }

    public static <T, U> List<U> map(Collection<T> collection, IMap<? super T, U> mapper) {
        if (CollectionsUtil.isEmpty(collection)) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList(collection.size());
        CollectionsUtil.map(collection, result, mapper);
        return result;
    }

    public static <T, U> List<U> map(Iterator<T> iterator, IMap<? super T, U> mapper) {
        if (iterator == null || mapper == null) {
            return Collections.emptyList();
        }
        ArrayList<U> result = new ArrayList<U>();
        while (iterator.hasNext()) {
            result.add(mapper.map(iterator.next()));
        }
        return result;
    }

    public static final <T> Set<T> newInOrderSet(T ... items) {
        return CollectionsUtil.addToSet(new LinkedHashSet(items != null ? items.length : 0), items);
    }

    public static final <T> List<T> newList(T ... items) {
        return CollectionsUtil.addToList(new ArrayList(items != null ? items.length : 0), items);
    }

    public static final <T> Set<T> newSet(T ... items) {
        return CollectionsUtil.addToSet(new HashSet(items != null ? items.length : 0), items);
    }

    public static final <T> Map<T, T> newMap(T ... items) {
        return CollectionsUtil.addToMap(new HashMap(items != null ? items.length / 2 : 0), items);
    }

    public static final <T, U> void addToMap(Class<T> keyType, Class<U> valueType, Map<T, U> map, Object ... items) {
        com.pandora.core.utils.CollectionsUtil.addToMap(keyType, valueType, map, (Object[])items);
    }

    public static final <T, U> Map<T, U> newTypedMap(Class<T> keyType, Class<U> valueType, Object ... items) {
        return com.pandora.core.utils.CollectionsUtil.newTypedMap(keyType, valueType, (Object[])items);
    }

    public static final <T, U extends T> Map<T, T> addToMap(Map<T, T> map, U ... items) {
        return com.pandora.core.utils.CollectionsUtil.addToMap(map, (Object[])items);
    }

    public static <T> void removeDuplicates(List<T> list) {
        LinkedHashSet<T> set = new LinkedHashSet<T>(list);
        list.clear();
        list.addAll(set);
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
    }

    public static <T> Collection<T> union(Collection<? extends T> collection1, Collection<? extends T> collection2) {
        if (CollectionsUtil.isEmpty(collection1)) {
            if (CollectionsUtil.isEmpty(collection2)) {
                return Collections.emptyList();
            }
            return new ArrayList<T>(collection2);
        }
        if (CollectionsUtil.isEmpty(collection2)) {
            return new ArrayList<T>(collection1);
        }
        HashSet<T> union = new HashSet<T>(collection1.size() + collection2.size());
        union.addAll(collection1);
        union.addAll(collection2);
        return new ArrayList(union);
    }

    private CollectionsUtil() {
    }

    public static <K, V> Map<K, V> mapFromValues(Collection<V> values, IMap<V, K> valueTokeyMapper) {
        if (CollectionsUtil.isEmpty(values)) {
            return Collections.emptyMap();
        }
        HashMap<K, V> map = new HashMap<K, V>(values.size());
        for (V value : values) {
            K key = valueTokeyMapper.map(value);
            if (key == null) {
                throw new IllegalStateException(MessageFormat.format("Generated key for value {0} was null, which is not allowed.", value.toString()));
            }
            map.put(key, value);
        }
        return map;
    }

    public static <K, V> K inject(Collection<V> collection, K collector, IInjectBlock<V, K> block) {
        if (CollectionsUtil.isEmpty(collection)) {
            return collector;
        }
        for (V item : collection) {
            collector = block.execute(collector, item);
        }
        return collector;
    }

    public static <T> T getDuplicateElement(List<T> propertys, T prop, Comparator<T> comparator) {
        for (T t : propertys) {
            if (comparator.compare(t, prop) != 0) continue;
            return t;
        }
        return null;
    }

    public static <T> boolean isNotEmpty(Collection<T> collection) {
        return !CollectionsUtil.isEmpty(collection);
    }
}

