/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import at.jta.Key;
import at.jta.RegistryErrorException;
import at.jta.Regor;
import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.BrowserUtilNull;
import com.aptana.core.util.IBrowserUtil;
import com.aptana.core.util.StringUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Plugin;

public class BrowserUtilWindows
extends BrowserUtilNull {
    private static String readKeyValue(Regor regor, Key key, String path) throws RegistryErrorException {
        return BrowserUtilWindows.readKeyValue(regor, key, path, "");
    }

    private static String readKeyValue(Regor regor, Key key, String path, String valueName) throws RegistryErrorException {
        Key openKey = regor.openKey(key, path, 131097);
        if (openKey != null) {
            try {
                byte[] buf = regor.readValue(openKey, valueName);
                if (buf != null) {
                    String string = BrowserUtilWindows.parseValue(buf);
                    return string;
                }
            }
            finally {
                regor.closeKey(openKey);
            }
        }
        return null;
    }

    public static String parseValue(byte[] buf) {
        return StringUtil.parseValue(buf);
    }

    @Override
    public List<IBrowserUtil.BrowserInfo> discoverInstalledBrowsers() {
        HashMap<String, IBrowserUtil.BrowserInfo> browsers = new HashMap<String, IBrowserUtil.BrowserInfo>();
        try {
            String path;
            Regor regor = new Regor();
            Key[] roots = new Key[]{Regor.HKEY_LOCAL_MACHINE, Regor.HKEY_CURRENT_USER};
            String[] stringArray = new String[]{"Software\\Clients\\StartMenuInternet", "Software\\WOW6432Node\\Clients\\StartMenuInternet"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                path = stringArray[n2];
                Key[] keyArray = roots;
                int n3 = roots.length;
                int n4 = 0;
                while (n4 < n3) {
                    Key root = keyArray[n4];
                    Key key = regor.openKey(root, path, 131097);
                    if (key != null) {
                        try {
                            List keys = regor.listKeys(key);
                            if (keys != null) {
                                for (String s : keys) {
                                    String browserName = BrowserUtilWindows.readKeyValue(regor, key, s);
                                    String browserLocation = BrowserUtilWindows.readKeyValue(regor, key, String.valueOf(s) + "\\shell\\open\\command");
                                    if (browserName == null || browserLocation == null) continue;
                                    if (browserLocation.startsWith("\"") && browserLocation.endsWith("\"")) {
                                        browserLocation = browserLocation.substring(1, browserLocation.length() - 1);
                                    }
                                    if (!new File(browserLocation).exists()) continue;
                                    browsers.put(browserLocation, new IBrowserUtil.BrowserInfo(browserName, browserLocation));
                                }
                            }
                        }
                        finally {
                            regor.closeKey(key);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            stringArray = new String[]{"SOFTWARE\\Core Services\\IETester", "SOFTWARE\\Wow6432Node\\Core Services\\IETester"};
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                path = stringArray[n2];
                Key key = regor.openKey(Regor.HKEY_LOCAL_MACHINE, path, 131097);
                if (key != null) {
                    try {
                        String browserLocation = regor.readValueAsString(key, "Install_Dir");
                        if (StringUtil.isNotBlank(browserLocation)) {
                            browserLocation = String.valueOf(browserLocation) + "\\IETester.exe";
                            browsers.put(browserLocation, new IBrowserUtil.BrowserInfo("IETester", browserLocation));
                        }
                    }
                    finally {
                        regor.closeKey(key);
                    }
                }
                ++n2;
            }
            if (this.isEdgeExist()) {
                String browserLocation = "cmd";
                IBrowserUtil.BrowserInfo info = new IBrowserUtil.BrowserInfo("Edge", browserLocation);
                info.setParameters("/c start Microsoft-Edge:%URL%");
                browsers.put(browserLocation, info);
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), e);
        }
        return new ArrayList<IBrowserUtil.BrowserInfo>(browsers.values());
    }

    @Override
    public String getBrowserVersion(IBrowserUtil.BrowserInfo info) {
        String name = info.getName();
        if (StringUtil.isEmpty(name)) {
            return null;
        }
        String lowerName = name.toLowerCase();
        if (lowerName.contains("opera")) {
            return this.getOperaVersion();
        }
        if (lowerName.contains("internet explorer")) {
            return this.getInternetExplorerVersion();
        }
        if (lowerName.contains("safari")) {
            return this.getSafariVersion();
        }
        if (lowerName.contains("chrome")) {
            return this.getChromeVersion();
        }
        if (lowerName.contains("firefox")) {
            return this.getFirefoxVersion();
        }
        return null;
    }

    private String getVersionFrom(String[] paths) {
        return this.getVersionFrom(paths, "");
    }

    private String getVersionFrom(String[] paths, String keyValue) {
        return this.getVersionFrom(paths, keyValue, Regor.HKEY_LOCAL_MACHINE);
    }

    private String getVersionFrom(String[] paths, String keyValue, Key key) {
        try {
            Regor regor = new Regor();
            String[] stringArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                String version = BrowserUtilWindows.readKeyValue(regor, key, path, keyValue);
                if (!StringUtil.isEmpty(version)) {
                    return version;
                }
                ++n2;
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), e);
        }
        return null;
    }

    private String getFirefoxVersion() {
        return this.getVersionFrom(new String[]{"Software\\Mozilla\\Mozilla Firefox\\", "Software\\WOW6432Node\\Mozilla\\Mozilla Firefox\\"});
    }

    private String getInternetExplorerVersion() {
        return this.getVersionFrom(new String[]{"Software\\Microsoft\\Internet Explorer\\", "Software\\WOW6432Node\\Microsoft\\Internet Explorer\\"}, "Version");
    }

    private String getSafariVersion() {
        return this.getVersionFrom(new String[]{"Software\\Apple Computer, Inc.\\Safari", "Software\\WOW6432Node\\Apple Computer, Inc.\\Safari"}, "Version");
    }

    private String getChromeVersion() {
        return this.getVersionFrom(new String[]{"Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Google Chrome", "Software\\WOW6432Node\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Google Chrome"}, "Version", Regor.HKEY_CURRENT_USER);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getOperaVersion() {
        try {
            Regor regor = new Regor();
            String[] stringArray = new String[]{"Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\", "Software\\WOW6432Node\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\"};
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return null;
                }
                String path = stringArray[n2];
                Key key = regor.openKey(Regor.HKEY_LOCAL_MACHINE, path, 131097);
                if (key != null) {
                    try {
                        List keys = regor.listKeys(key);
                        if (keys != null) {
                            for (String s : keys) {
                                String version;
                                String publisher;
                                if (!s.toLowerCase().startsWith("opera") || StringUtil.isEmpty(publisher = BrowserUtilWindows.readKeyValue(regor, key, s, "Publisher")) || !publisher.toLowerCase().startsWith("opera software") || StringUtil.isEmpty(version = BrowserUtilWindows.readKeyValue(regor, key, s, "DisplayVersion"))) continue;
                                String string = version;
                                return string;
                            }
                        }
                    }
                    finally {
                        regor.closeKey(key);
                    }
                }
                ++n2;
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), e);
        }
        return null;
    }

    protected boolean isEdgeExist() {
        String[] names;
        File systemApps = new File("C:\\Windows\\SystemApps\\");
        return systemApps.exists() && systemApps.isDirectory() && (names = systemApps.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("Microsoft.MicrosoftEdge_");
            }
        })) != null && names.length > 0;
    }
}

