/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.BrowserUtilNull;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.IBrowserUtil;
import com.aptana.core.util.ProcessUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.plist.PListParserFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;

public class BrowserUtilMac
extends BrowserUtilNull {
    private static final IPath CHROME_PLIST = Path.fromPortableString((String)"/Applications/Google Chrome.app/Contents/Info.plist");
    private static final IPath SAFARI_PLIST = Path.fromPortableString((String)"/Applications/Safari.app/Contents/Info.plist");
    private static final IPath OPERA_PLIST = Path.fromPortableString((String)"/Applications/Opera.app/Contents/Info.plist");
    private static final String PLIST_VERSION_KEY = "CFBundleShortVersionString";
    private static final Map<String, String> MAC_BROWSER_LOCATIONS = CollectionsUtil.newMap("Chrome", "/Applications/Google Chrome.app", "Safari", "/Applications/Safari.app", "Firefox", "/Applications/Firefox.app", "Opera", "/Applications/Opera.app");

    @Override
    public List<IBrowserUtil.BrowserInfo> discoverInstalledBrowsers() {
        ArrayList<IBrowserUtil.BrowserInfo> browsers = new ArrayList<IBrowserUtil.BrowserInfo>();
        try {
            Set<String> browserNames = MAC_BROWSER_LOCATIONS.keySet();
            for (String name : browserNames) {
                String location = MAC_BROWSER_LOCATIONS.get(name);
                if (!new File(location).exists()) continue;
                browsers.add(new IBrowserUtil.BrowserInfo(name, location));
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), e);
        }
        return browsers;
    }

    @Override
    public String getBrowserVersion(IBrowserUtil.BrowserInfo info) {
        String name = info.getName();
        if (StringUtil.isEmpty(name)) {
            return null;
        }
        String lowerName = name.toLowerCase();
        if (lowerName.contains("opera")) {
            return this.getOperaVersion();
        }
        if (lowerName.contains("safari")) {
            return this.getSafariVersion();
        }
        if (lowerName.contains("chrome")) {
            return this.getChromeVersion();
        }
        if (lowerName.contains("firefox")) {
            return this.getFirefoxVersion(info);
        }
        return null;
    }

    private String getFirefoxVersion(IBrowserUtil.BrowserInfo info) {
        IStatus status = ProcessUtil.runInBackground(info.getLocation(), (IPath)Path.ROOT, "-v");
        if (status == null || !status.isOK()) {
            return null;
        }
        String output = status.getMessage();
        List<String> parts = StringUtil.split(output, ' ');
        return parts.get(parts.size() - 1);
    }

    private String getOperaVersion() {
        return this.getPlistKeyValue(OPERA_PLIST, PLIST_VERSION_KEY);
    }

    private String getSafariVersion() {
        return this.getPlistKeyValue(SAFARI_PLIST, PLIST_VERSION_KEY);
    }

    private String getChromeVersion() {
        return this.getPlistKeyValue(CHROME_PLIST, PLIST_VERSION_KEY);
    }

    private String getPlistKeyValue(IPath plistPath, String key) {
        try {
            Map<String, Object> dict = PListParserFactory.parse(plistPath.toFile());
            return (String)dict.get(key);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

