/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.projects.templates;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.projects.templates.IProjectTemplate;
import com.aptana.core.projects.templates.Messages;
import com.aptana.core.projects.templates.TemplateAbility;
import com.aptana.core.projects.templates.TemplateType;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.IOUtil;
import com.aptana.core.util.SourcePrinter;
import com.aptana.core.util.StringUtil;
import com.aptana.core.util.ZipUtil;
import com.aptana.core.util.replace.SimpleTextPatternReplacer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

public class ProjectTemplate
implements IProjectTemplate {
    private TemplateType type;
    private TemplateAbility ability = TemplateAbility.TEMPLATE;
    private String path;
    private String description;
    private String name;
    private String id;
    private URL iconURL;
    private boolean isReplacingParameters;
    private int priority;
    private List<String> tags;
    private String natureID;

    public ProjectTemplate(String path, TemplateType type, String name, boolean isReplacingParameters, String description, URL iconURL, String id) {
        this(path, type, name, isReplacingParameters, description, iconURL, id, 0, null);
    }

    public ProjectTemplate(String path, TemplateType type, String name, boolean isReplacingParameters, String description, URL iconURL, String id, int priority, List<String> tags) {
        this(path, type, name, isReplacingParameters, description, iconURL, id, priority, tags, null);
    }

    public ProjectTemplate(String path, TemplateType type, String name, boolean isReplacingParameters, String description, URL iconURL, String id, int priority, List<String> tags, String natureID) {
        this.type = type;
        this.path = path;
        this.name = name;
        this.isReplacingParameters = isReplacingParameters;
        this.description = description;
        this.iconURL = iconURL;
        this.id = id;
        this.priority = priority;
        this.tags = CollectionsUtil.isEmpty(tags) ? null : new ArrayList<String>(tags);
        this.natureID = natureID;
    }

    public ProjectTemplate(String path, TemplateType type, TemplateAbility ability, String name, boolean isReplacingParameters, String description, URL iconURL, String id, int priority, List<String> tags) {
        this(path, type, ability, name, isReplacingParameters, description, iconURL, id, priority, tags, null);
    }

    public ProjectTemplate(String path, TemplateType type, TemplateAbility ability, String name, boolean isReplacingParameters, String description, URL iconURL, String id, int priority, List<String> tags, String natureID) {
        this.type = type;
        this.ability = ability == null ? TemplateAbility.TEMPLATE : ability;
        this.path = path;
        this.name = name;
        this.isReplacingParameters = isReplacingParameters;
        this.description = description;
        this.iconURL = iconURL;
        this.id = id;
        this.priority = priority;
        this.tags = CollectionsUtil.isEmpty(tags) ? null : new ArrayList<String>(tags);
        this.natureID = natureID;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public File getDirectory() {
        return new File(this.path).getParentFile();
    }

    @Override
    public String getLocation() {
        return Path.fromOSString((String)this.path).lastSegment();
    }

    @Override
    public TemplateType getType() {
        return this.type;
    }

    @Override
    public TemplateAbility getAbility() {
        return this.ability;
    }

    @Override
    public URL getIconURL() {
        return this.iconURL;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public boolean isReplacingParameters() {
        return this.isReplacingParameters;
    }

    protected void toSource(SourcePrinter printer) {
    }

    public String toString() {
        SourcePrinter printer = new SourcePrinter();
        printer.printWithIndent("project_template");
        printer.print(" \"").print(this.getDisplayName()).println("\" {").increaseIndent();
        ProjectTemplate.printBody(printer, false, this);
        printer.decreaseIndent().printlnWithIndent("}");
        return printer.toString();
    }

    public static void printBody(SourcePrinter printer, boolean includeBlocks, IProjectTemplate template) {
        printer.printWithIndent("path: ").println(template.getPath());
        printer.printWithIndent("name: ").println(template.getDisplayName());
        printer.printWithIndent("location: ").println(template.getLocation());
        printer.printWithIndent("id: ").println(template.getId());
        printer.printWithIndent("type: ").println(template.getType().name());
        printer.printWithIndent("replaceParameters: ").println(Boolean.toString(template.isReplacingParameters()));
        if (template.getDescription() != null) {
            printer.printWithIndent("description: ").println(template.getDescription());
        }
        if (template.getIconURL() != null) {
            printer.printWithIndent("iconURL: ").println(template.getIconURL().toString());
        }
        if (!CollectionsUtil.isEmpty(template.getTags())) {
            printer.printlnWithIndent("tags: ").println(StringUtil.join(",", template.getTags()));
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IStatus apply(IProject project, boolean promptForOverwrite) {
        TemplateSubstitutionTransformer transform = new TemplateSubstitutionTransformer(project);
        File zipFile = new File(this.getDirectory(), this.getLocation());
        try {
            return ZipUtil.extract(zipFile, project.getLocation().toFile(), promptForOverwrite ? ZipUtil.Conflict.PROMPT : ZipUtil.Conflict.OVERWRITE, transform, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException e) {
            return new Status(4, "com.aptana.core", 0, MessageFormat.format("IOException reading zipfile {0}", zipFile.getAbsolutePath()), (Throwable)e);
        }
    }

    private static boolean isSupportedFile(IFile file) {
        IContentTypeManager manager = Platform.getContentTypeManager();
        if (manager == null) {
            return false;
        }
        IContentType contentType = manager.findContentTypeFor(file.getName());
        if (contentType == null) {
            return false;
        }
        IContentType text = manager.getContentType("org.eclipse.core.runtime.text");
        return contentType.isKindOf(text);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String applyTemplateVariables(InputStream inputStream, IFile file, IProject project) throws CoreException {
        String string;
        SimpleTextPatternReplacer replacer = new SimpleTextPatternReplacer();
        try {
            IPath absoluteFilePath = file.getLocation();
            String filePathString = absoluteFilePath.toOSString();
            replacer.addPattern("${TM_NEW_FILE_BASENAME}", absoluteFilePath.removeFileExtension().lastSegment());
            replacer.addPattern("${TM_NEW_FILE}", filePathString);
            replacer.addPattern("${TM_NEW_FILE_DIRECTORY}", absoluteFilePath.removeLastSegments(1).toOSString());
            replacer.addPattern("${TM_PROJECTNAME}", project.getName());
            Calendar calendar = Calendar.getInstance();
            replacer.addPattern("${TIME}", calendar.getTime().toString());
            replacer.addPattern("${YEAR}", Integer.toString(calendar.get(1)));
            String text = IOUtil.read(inputStream);
            string = replacer.searchAndReplace(text);
            if (inputStream == null) return string;
        }
        catch (Exception exception) {
            try {
                throw new CoreException((IStatus)new Status(4, "com.aptana.core", Messages.NewProjectWizard_templateVariableApplyError));
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            inputStream.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
    }

    @Override
    public String getNatureID() {
        return this.natureID;
    }

    private final class TemplateSubstitutionTransformer
    implements ZipUtil.IInputStreamTransformer {
        private final IProject project;

        private TemplateSubstitutionTransformer(IProject project) {
            this.project = project;
        }

        @Override
        public InputStream transform(InputStream in, IPath relativePath) {
            if (!ProjectTemplate.this.isReplacingParameters) {
                return in;
            }
            IFile file = this.project.getFile(relativePath);
            if (!ProjectTemplate.isSupportedFile(file)) {
                return in;
            }
            String content = null;
            try {
                content = ProjectTemplate.applyTemplateVariables(in, file, this.project);
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CorePlugin.getDefault(), "Error applying a template. Trying to write the file as is, without template evaluation.", e);
            }
            if (content == null) {
                content = IOUtil.read(in);
            }
            try {
                return new ByteArrayInputStream(content.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return in;
            }
        }
    }
}

