/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.build;

import com.aptana.core.build.IProblem;
import com.aptana.core.util.ObjectUtil;
import java.util.HashMap;
import java.util.Map;

public class Problem
implements IProblem {
    private int severity;
    private String message;
    private int offset;
    private int length;
    private int lineNumber;
    private String sourcePath;
    private int priority;
    private Map<String, Object> fAttributes;
    private boolean quickFixable;

    public Problem() {
    }

    public Problem(int severity, String message, int offset, int length, int lineNumber, String sourcePath) {
        this(severity, message, offset, length, lineNumber, sourcePath, 1);
    }

    public Problem(int severity, String message, int offset, int length, int lineNumber, String sourcePath, int priority) {
        this.severity = severity;
        this.message = message;
        this.offset = offset;
        this.length = length;
        this.lineNumber = lineNumber;
        this.sourcePath = sourcePath;
        this.priority = priority;
        this.fAttributes = new HashMap<String, Object>(3);
    }

    @Override
    public void setAttribute(String attrName, Object value) {
        this.fAttributes.put(attrName, value);
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public IProblem.Severity getSeverity() {
        return IProblem.Severity.create(this.severity);
    }

    @Override
    public String getSourcePath() {
        return this.sourcePath;
    }

    @Override
    public Map<String, Object> createMarkerAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.putAll(this.getAttributes());
        attributes.put("severity", this.getSeverity().intValue());
        int length = this.getLength();
        if (length > 0) {
            attributes.put("charStart", this.getOffset());
            attributes.put("charEnd", this.getOffset() + length);
        }
        attributes.put("message", this.getMessage());
        attributes.put("lineNumber", this.getLineNumber());
        return attributes;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.fAttributes;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Problem)) {
            return false;
        }
        Problem other = (Problem)obj;
        return this.severity == other.severity && this.priority == other.priority && this.offset == other.offset && this.length == other.length && ObjectUtil.areEqual(this.message, other.message) && ObjectUtil.areEqual(this.sourcePath, other.sourcePath);
    }

    public int hashCode() {
        int hash = this.severity;
        hash = hash * 31 + this.priority;
        hash = hash * 31 + this.offset;
        hash = hash * 31 + this.length;
        hash = hash * 31 + this.message.hashCode();
        hash = hash * 31 + this.sourcePath.hashCode();
        return hash;
    }

    @Override
    public boolean isError() {
        return this.severity == 2;
    }

    @Override
    public boolean isWarning() {
        return this.severity == 1;
    }

    @Override
    public boolean isTask() {
        return this.severity == 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("problem ");
        if (this.isError()) {
            buf.append("ERROR");
        } else if (this.isWarning()) {
            buf.append("WARNING");
        } else if (this.severity == 0) {
            buf.append("INFO");
        } else {
            buf.append("severity=");
            buf.append(this.severity);
        }
        buf.append(": ");
        buf.append(this.getSourcePath());
        buf.append(" line=");
        buf.append(this.getLineNumber());
        buf.append(" offset=");
        buf.append(this.getOffset());
        buf.append(" length=");
        buf.append(this.getLength());
        buf.append(' ');
        buf.append(this.message);
        return buf.toString();
    }

    public void setQuickFixable(boolean quickFixable) {
        this.quickFixable = quickFixable;
    }

    @Override
    public boolean isQuickFixable() {
        return this.quickFixable;
    }
}

