/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.preferences;

import com.aptana.ide.core.io.preferences.CloakingUtils;
import com.aptana.ide.ui.io.IOUIPlugin;
import com.aptana.ide.ui.io.dialogs.CloakExpressionDialog;
import com.aptana.ide.ui.io.preferences.Messages;
import com.aptana.ide.ui.io.preferences.RemotePreferenceUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class RemotePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String ADD_ICON = "icons/full/etool16/add.png";
    private static final String REMOVE_ICON = "icons/full/etool16/delete.png";
    private Button removeButton;
    private TableViewer tableViewer;
    private Button fReopenButton;
    private Set<String> expressions = new HashSet<String>();

    public void init(IWorkbench workbench) {
        this.setDescription(Messages.RemotePreferencePage_LBL_Description);
        this.loadCloakingExpressions();
    }

    protected Control createContents(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        Composite cloaking = this.createCloakingComposite(main);
        cloaking.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.fReopenButton = new Button(main, 32);
        this.fReopenButton.setText(Messages.RemotePreferencePage_LBL_ReopenRemote);
        this.fReopenButton.setSelection(RemotePreferenceUtil.getReopenRemoteOnStartup());
        this.fReopenButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        return main;
    }

    protected void performDefaults() {
        this.expressions.clear();
        this.expressions.addAll(Arrays.asList(CloakingUtils.getDefaultCloakedFileTypes()));
        this.tableViewer.refresh();
        this.fReopenButton.setSelection(false);
        super.performDefaults();
    }

    public boolean performOk() {
        this.saveCloakingExpressions();
        RemotePreferenceUtil.setReopenRemoteOnStartup(this.fReopenButton.getSelection());
        return super.performOk();
    }

    private Composite createCloakingComposite(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        Button addButton = new Button(main, 8);
        addButton.setImage(IOUIPlugin.getImage(ADD_ICON));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemotePreferencePage.this.add();
            }
        });
        this.removeButton = new Button(main, 8);
        this.removeButton.setImage(IOUIPlugin.getImage(REMOVE_ICON));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemotePreferencePage.this.remove();
            }
        });
        this.tableViewer = new TableViewer(main, 67586);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).grab(true, true).create());
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.tableViewer.setInput(this.expressions);
        this.tableViewer.setComparator(new ViewerComparator());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RemotePreferencePage.this.updateButtonState();
            }
        });
        this.updateButtonState();
        return main;
    }

    private void add() {
        CloakExpressionDialog dialog = new CloakExpressionDialog(this.getShell());
        if (dialog.open() == 0) {
            this.expressions.add(dialog.getExpression());
            this.tableViewer.refresh();
        }
    }

    private void remove() {
        Object[] elements;
        Object[] objectArray = elements = ((IStructuredSelection)this.tableViewer.getSelection()).toArray();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.expressions.remove(element.toString());
            ++n2;
        }
        this.tableViewer.refresh();
    }

    private void updateButtonState() {
        boolean hasSelection = !this.tableViewer.getSelection().isEmpty();
        this.removeButton.setEnabled(hasSelection);
    }

    private void loadCloakingExpressions() {
        this.expressions.addAll(Arrays.asList(CloakingUtils.getCloakedFileTypes()));
    }

    private void saveCloakingExpressions() {
        CloakingUtils.setCloakedFileTypes((String[])this.expressions.toArray(new String[this.expressions.size()]));
    }
}

