/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.preferences;

import com.aptana.core.util.StringUtil;
import com.aptana.ide.ui.io.preferences.Messages;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PermissionsGroup
extends Composite {
    private Button fUserRead;
    private Button fUserWrite;
    private Button fUserExecute;
    private Button fGroupRead;
    private Button fGroupWrite;
    private Button fGroupExecute;
    private Button fAllRead;
    private Button fAllWrite;
    private Button fAllExecute;
    private Set<Listener> fListeners;

    public PermissionsGroup(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(4).spacing(5, 0).create());
        this.fListeners = new LinkedHashSet<Listener>();
        Label label = new Label((Composite)this, 0);
        label.setText(StringUtil.makeFormLabel((String)Messages.PermissionsGroup_User));
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PermissionsGroup.this.firePermissionsModified();
            }
        };
        this.fUserRead = this.createPermissionButton(Messages.PermissionsGroup_Read, (SelectionListener)selectionAdapter);
        this.fUserWrite = this.createPermissionButton(Messages.PermissionsGroup_Write, (SelectionListener)selectionAdapter);
        this.fUserExecute = this.createPermissionButton(Messages.PermissionsGroup_Execute, (SelectionListener)selectionAdapter);
        label = new Label((Composite)this, 0);
        label.setText(StringUtil.makeFormLabel((String)Messages.PermissionsGroup_Group));
        this.fGroupRead = this.createPermissionButton(Messages.PermissionsGroup_Read, (SelectionListener)selectionAdapter);
        this.fGroupWrite = this.createPermissionButton(Messages.PermissionsGroup_Write, (SelectionListener)selectionAdapter);
        this.fGroupExecute = this.createPermissionButton(Messages.PermissionsGroup_Execute, (SelectionListener)selectionAdapter);
        label = new Label((Composite)this, 0);
        label.setText(StringUtil.makeFormLabel((String)Messages.PermissionsGroup_All));
        this.fAllRead = this.createPermissionButton(Messages.PermissionsGroup_Read, (SelectionListener)selectionAdapter);
        this.fAllWrite = this.createPermissionButton(Messages.PermissionsGroup_Write, (SelectionListener)selectionAdapter);
        this.fAllExecute = this.createPermissionButton(Messages.PermissionsGroup_Execute, (SelectionListener)selectionAdapter);
    }

    public void addListener(Listener listener) {
        this.fListeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.fListeners.remove(listener);
    }

    public long getPermissions() {
        long permissions = 0L;
        permissions |= this.fUserRead.getSelection() ? 256L : 0L;
        permissions |= this.fUserWrite.getSelection() ? 128L : 0L;
        permissions |= this.fUserExecute.getSelection() ? 64L : 0L;
        permissions |= this.fGroupRead.getSelection() ? 32L : 0L;
        permissions |= this.fGroupWrite.getSelection() ? 16L : 0L;
        permissions |= this.fGroupExecute.getSelection() ? 8L : 0L;
        permissions |= this.fAllRead.getSelection() ? 4L : 0L;
        permissions |= this.fAllWrite.getSelection() ? 2L : 0L;
        return permissions |= this.fAllExecute.getSelection() ? 1L : 0L;
    }

    public void setPermissions(long permissions) {
        this.fUserRead.setSelection((permissions & 0x100L) != 0L);
        this.fUserWrite.setSelection((permissions & 0x80L) != 0L);
        this.fUserExecute.setSelection((permissions & 0x40L) != 0L);
        this.fGroupRead.setSelection((permissions & 0x20L) != 0L);
        this.fGroupWrite.setSelection((permissions & 0x10L) != 0L);
        this.fGroupExecute.setSelection((permissions & 8L) != 0L);
        this.fAllRead.setSelection((permissions & 4L) != 0L);
        this.fAllWrite.setSelection((permissions & 2L) != 0L);
        this.fAllExecute.setSelection((permissions & 1L) != 0L);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.fUserRead.setEnabled(enabled);
        this.fUserWrite.setEnabled(enabled);
        this.fUserExecute.setEnabled(enabled);
        this.fGroupRead.setEnabled(enabled);
        this.fGroupWrite.setEnabled(enabled);
        this.fGroupExecute.setEnabled(enabled);
        this.fAllRead.setEnabled(enabled);
        this.fAllWrite.setEnabled(enabled);
        this.fAllExecute.setEnabled(enabled);
    }

    private void firePermissionsModified() {
        for (Listener listener : this.fListeners) {
            listener.permissionsModified();
        }
    }

    private Button createPermissionButton(String text, SelectionListener listener) {
        Button button = new Button((Composite)this, 32);
        button.setText(text);
        button.addSelectionListener(listener);
        return button;
    }

    public static interface Listener {
        public void permissionsModified();
    }
}

