/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator.resources;

import com.aptana.ide.ui.io.FileSystemUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.navigator.resources.ResourceDragAdapterAssistant;

public class FileDragAdapterAssistant
extends ResourceDragAdapterAssistant {
    private static final Transfer[] SUPPORTED_TRANSFERS = new Transfer[]{FileTransfer.getInstance()};

    public Transfer[] getSupportedTransferTypes() {
        return SUPPORTED_TRANSFERS;
    }

    public boolean setDragData(DragSourceEvent anEvent, IStructuredSelection aSelection) {
        boolean result = super.setDragData(anEvent, aSelection);
        if (result) {
            return true;
        }
        IFileStore[] fileStores = this.getSelectedFiles(aSelection);
        if (fileStores.length > 0) {
            if (LocalSelectionTransfer.getTransfer().isSupportedType(anEvent.dataType)) {
                anEvent.data = fileStores;
                return true;
            }
            if (FileTransfer.getInstance().isSupportedType(anEvent.dataType)) {
                ArrayList<String> filenames = new ArrayList<String>();
                IFileStore[] iFileStoreArray = fileStores;
                int n = fileStores.length;
                int n2 = 0;
                while (n2 < n) {
                    IFileStore fileStore = iFileStoreArray[n2];
                    try {
                        File file = fileStore.toLocalFile(4096, null);
                        if (file != null) {
                            filenames.add(file.getAbsolutePath());
                        }
                    }
                    catch (CoreException coreException) {}
                    ++n2;
                }
                if (filenames.isEmpty()) {
                    return false;
                }
                anEvent.data = filenames.toArray(new String[filenames.size()]);
                return true;
            }
        }
        return false;
    }

    private IFileStore[] getSelectedFiles(IStructuredSelection aSelection) {
        Object[] selectedElements;
        LinkedHashSet<IFileStore> files = new LinkedHashSet<IFileStore>();
        Object[] objectArray = selectedElements = aSelection.toArray();
        int n = selectedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object selected = objectArray[n2];
            IFileStore file = FileSystemUtils.getFileStore(selected);
            if (file != null) {
                files.add(file);
            }
            ++n2;
        }
        return files.toArray(new IFileStore[files.size()]);
    }
}

