/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator.actions;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.ide.ui.io.IOUIPlugin;
import com.aptana.ide.ui.io.IUniformFileStoreEditorInput;
import com.aptana.ide.ui.io.internal.UniformFileStoreEditorInputFactory;
import com.aptana.ide.ui.io.navigator.actions.Messages;
import com.aptana.ui.util.UIUtils;
import java.text.MessageFormat;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class EditorUtils {
    public static void openFileInEditor(IFileStore fileStore, IEditorDescriptor editorDescriptor) {
        EditorUtils.openFileInEditor(fileStore, editorDescriptor, null);
    }

    public static void openFileInEditor(final IFileStore fileStore, final IEditorDescriptor editorDescriptor, final TextSelection textSelection) {
        Job job = new Job(MessageFormat.format(Messages.EditorUtils_OpeningEditor, fileStore.getName())){

            protected IStatus run(IProgressMonitor monitor) {
                IEditorInput editorInput;
                try {
                    editorInput = UniformFileStoreEditorInputFactory.getUniformEditorInput(fileStore, monitor);
                }
                catch (CoreException e) {
                    UIUtils.showErrorMessage((String)MessageFormat.format(Messages.EditorUtils_OpeningEditor, fileStore.toString()), (Throwable)e);
                    IdeLog.logError((Plugin)IOUIPlugin.getDefault(), (String)MessageFormat.format("Unable to open file {0}", fileStore.toString()), (Throwable)e);
                    return Status.CANCEL_STATUS;
                }
                UIJob openEditor = new UIJob(MessageFormat.format(Messages.EditorUtils_OpeningEditor, fileStore.toString())){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        try {
                            IWorkbenchPage page = UIUtils.getActivePage();
                            if (page != null) {
                                IEditorPart editorPart;
                                IFile file = EditorUtils.findFileInWorkspace(fileStore);
                                if (file == null) {
                                    String name = editorInput instanceof IUniformFileStoreEditorInput ? ((IUniformFileStoreEditorInput)editorInput).getFileStore().getName() : editorInput.getName();
                                    String editorId = editorDescriptor == null ? IDE.getEditorDescriptor((String)name).getId() : editorDescriptor.getId();
                                    int matchFlags = 3;
                                    editorPart = page.openEditor(editorInput, editorId, true, matchFlags);
                                } else {
                                    editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                                }
                                if (textSelection != null && editorPart instanceof AbstractTextEditor) {
                                    AbstractTextEditor editor = (AbstractTextEditor)editorPart;
                                    editor.selectAndReveal(textSelection.getOffset(), textSelection.getLength());
                                }
                            }
                        }
                        catch (Exception e) {
                            return new Status(4, "com.aptana.ui.io", null, (Throwable)e);
                        }
                        return Status.OK_STATUS;
                    }
                };
                EclipseUtil.setSystemForJob((Job)openEditor);
                openEditor.schedule();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private static IFile findFileInWorkspace(IFileStore fileStore) {
        if (fileStore == null) {
            return null;
        }
        IResource resource = (IResource)fileStore.getAdapter(IResource.class);
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        Object[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(fileStore.toURI());
        return ArrayUtil.isEmpty((Object[])files) ? null : files[0];
    }
}

