/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator;

import com.aptana.core.logging.IdeLog;
import com.aptana.ide.ui.io.IOUIPlugin;
import com.aptana.ide.ui.io.internal.UniformFileStoreEditorInputFactory;
import com.aptana.ide.ui.io.navigator.FileSystemObject;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.navigator.ILinkHelper;

public class FilesystemLinkHelper
implements ILinkHelper {
    public IStructuredSelection findSelection(IEditorInput anInput) {
        IFileStore fileStore = (IFileStore)anInput.getAdapter(IFileStore.class);
        IFileInfo fileInfo = (IFileInfo)anInput.getAdapter(IFileInfo.class);
        if (fileStore == null || fileInfo == null) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection((Object)new FileSystemObject(fileStore, fileInfo));
    }

    public void activateEditor(IWorkbenchPage aPage, IStructuredSelection aSelection) {
        if (aSelection == null || aSelection.isEmpty()) {
            return;
        }
        Object element = aSelection.getFirstElement();
        if (element instanceof FileSystemObject) {
            FileSystemObject file = (FileSystemObject)element;
            IFileStore fileStore = file.getFileStore();
            try {
                IEditorPart editorPart = aPage.findEditor(UniformFileStoreEditorInputFactory.getUniformEditorInput(fileStore, (IProgressMonitor)new NullProgressMonitor()));
                aPage.bringToTop((IWorkbenchPart)editorPart);
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)IOUIPlugin.getDefault(), (Throwable)e);
            }
        }
    }
}

