/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator;

import com.aptana.core.logging.IdeLog;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.io.IConnectionPointCategory;
import com.aptana.ide.core.io.IConnectionPointManager;
import com.aptana.ide.core.io.LocalConnectionPoint;
import com.aptana.ide.core.io.LocalRoot;
import com.aptana.ide.core.io.WorkspaceConnectionPoint;
import com.aptana.ide.ui.io.CoreIOImages;
import com.aptana.ide.ui.io.FileSystemUtils;
import com.aptana.ide.ui.io.IOUIPlugin;
import com.aptana.ide.ui.io.ImageUtils;
import com.aptana.ide.ui.io.navigator.FileSystemObject;
import com.aptana.ide.ui.io.navigator.Messages;
import com.aptana.ui.ImageAssociations;
import com.aptana.ui.util.UIUtils;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class FileSystemWorkbenchAdapter
implements IWorkbenchAdapter,
IDeferredWorkbenchAdapter {
    private static FileSystemWorkbenchAdapter instance;
    private static final Object[] EMPTY;

    static {
        EMPTY = new Object[0];
    }

    protected FileSystemWorkbenchAdapter() {
    }

    static synchronized FileSystemWorkbenchAdapter getInstance() {
        if (instance == null) {
            instance = new FileSystemWorkbenchAdapter();
        }
        return instance;
    }

    public Object[] getChildren(Object object) {
        block16: {
            if (object instanceof IConnectionPoint) {
                IConnectionPoint connectionPoint = (IConnectionPoint)object;
                if (object instanceof WorkspaceConnectionPoint) {
                    IContainer container = ((WorkspaceConnectionPoint)object).getResource();
                    if (container == null) {
                        return EMPTY;
                    }
                    try {
                        return container.members();
                    }
                    catch (CoreException e) {
                        IdeLog.logWarning((Plugin)IOUIPlugin.getDefault(), (String)Messages.FileSystemWorkbenchAdapter_FailedToGetMembers, (Throwable)e);
                        break block16;
                    }
                }
                try {
                    return FileSystemWorkbenchAdapter.fetchFileSystemChildren(connectionPoint.getRoot(), (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    try {
                        connectionPoint.connect(true, (IProgressMonitor)new NullProgressMonitor());
                        return FileSystemWorkbenchAdapter.fetchFileSystemChildren(connectionPoint.getRoot(), (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException coreException) {
                        IdeLog.logError((Plugin)IOUIPlugin.getDefault(), (String)Messages.FileSystemWorkbenchAdapter_FailedToFetchChildren, (Throwable)e);
                        UIUtils.showErrorMessage((String)Messages.FileSystemWorkbenchAdapter_FailedToFetchChildren, (Throwable)e);
                        break block16;
                    }
                }
            }
            if (object instanceof IConnectionPointCategory) {
                return ((IConnectionPointCategory)object).getConnectionPoints();
            }
            if (object instanceof LocalRoot) {
                try {
                    return FileSystemWorkbenchAdapter.fetchFileSystemChildren(((LocalRoot)object).getRoot(), (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)IOUIPlugin.getDefault(), (String)Messages.FileSystemWorkbenchAdapter_FailedToFetchChildren, (Throwable)e);
                    UIUtils.showErrorMessage((String)Messages.FileSystemWorkbenchAdapter_FailedToFetchChildren, (Throwable)e);
                }
            } else if (object instanceof IConnectionPointManager) {
                ArrayList<IConnectionPointCategory> list = new ArrayList<IConnectionPointCategory>();
                IConnectionPointCategory[] iConnectionPointCategoryArray = ((IConnectionPointManager)object).getConnectionPointCategories();
                int n = iConnectionPointCategoryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConnectionPointCategory category = iConnectionPointCategoryArray[n2];
                    list.add(category);
                    ++n2;
                }
                return list.toArray();
            }
        }
        return EMPTY;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        if (object instanceof FileSystemObject) {
            ImageDescriptor imageDescriptor;
            FileSystemObject fsObject = (FileSystemObject)object;
            if (fsObject.isDirectory()) {
                return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
            }
            File file = (File)fsObject.getAdapter(File.class);
            if (file != null && (imageDescriptor = ImageUtils.getImageDescriptor(file)) != null) {
                return imageDescriptor;
            }
            return ImageUtils.getImageDescriptor(fsObject.getName());
        }
        if (object instanceof LocalRoot) {
            File file = ((LocalRoot)object).getFile();
            ImageDescriptor imageDescriptor = ImageUtils.getImageDescriptor(file);
            if (imageDescriptor != null) {
                return imageDescriptor;
            }
            if (file.getParentFile() == null) {
                return CoreIOImages.getImageDescriptor("IMG_OBJS_DRIVE");
            }
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
        }
        if (object instanceof WorkspaceConnectionPoint) {
            IWorkbenchAdapter workbenchAdapter;
            IContainer resource = ((WorkspaceConnectionPoint)object).getResource();
            if (resource != null && (workbenchAdapter = (IWorkbenchAdapter)resource.getAdapter(IWorkbenchAdapter.class)) != null) {
                return workbenchAdapter.getImageDescriptor((Object)resource);
            }
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
        }
        if (object instanceof IConnectionPoint) {
            ImageDescriptor image = ImageAssociations.getInstance().getImageDescriptor(object);
            if (image != null) {
                return image;
            }
            if (object instanceof LocalConnectionPoint) {
                return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
            }
            return CoreIOImages.getImageDescriptor("IMG_OBJS_CONNECTION");
        }
        if (object instanceof IConnectionPointCategory) {
            ImageDescriptor image = ImageAssociations.getInstance().getImageDescriptor(object);
            if (image != null) {
                return image;
            }
            return CoreIOImages.getImageDescriptor("IMG_OBJS_SYMLINK");
        }
        return null;
    }

    public String getLabel(Object object) {
        if (object instanceof FileSystemObject) {
            return ((FileSystemObject)object).getName();
        }
        if (object instanceof IFileStore) {
            return ((IFileStore)object).getName();
        }
        if (object instanceof IConnectionPoint) {
            return ((IConnectionPoint)object).getName();
        }
        if (object instanceof IConnectionPointCategory) {
            return ((IConnectionPointCategory)object).getName();
        }
        if (object instanceof LocalRoot) {
            return ((LocalRoot)object).getName();
        }
        return String.valueOf(object);
    }

    public Object getParent(Object object) {
        IFileStore fileStore;
        IFileStore parentFileStore;
        if (object instanceof FileSystemObject && (parentFileStore = (fileStore = ((FileSystemObject)object).getFileStore()).getParent()) != null) {
            try {
                IFileInfo parentFileInfo = parentFileStore.fetchInfo(0, (IProgressMonitor)new NullProgressMonitor());
                return new FileSystemObject(parentFileStore, parentFileInfo);
            }
            catch (CoreException e) {
                IdeLog.logWarning((Plugin)IOUIPlugin.getDefault(), (Throwable)e);
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ISchedulingRule getRule(Object object) {
        if (object instanceof IAdaptable) {
            return (ISchedulingRule)((IAdaptable)object).getAdapter(ISchedulingRule.class);
        }
        return null;
    }

    public boolean isContainer() {
        return true;
    }

    private static FileSystemObject[] fetchFileSystemChildren(IFileStore parent, IProgressMonitor monitor) throws CoreException {
        IFileInfo[] fileInfos = FileSystemUtils.childInfos(parent, 0, monitor);
        ArrayList<FileSystemObject> list = new ArrayList<FileSystemObject>();
        IFileInfo[] iFileInfoArray = fileInfos;
        int n = fileInfos.length;
        int n2 = 0;
        while (n2 < n) {
            IFileInfo fi = iFileInfoArray[n2];
            list.add(new FileSystemObject(parent.getChild(fi.getName()), fi));
            ++n2;
        }
        return list.toArray(new FileSystemObject[list.size()]);
    }

    public static class Factory
    implements IAdapterFactory {
        public Object getAdapter(Object adaptableObject, Class adapterType) {
            if (IWorkbenchAdapter.class.equals((Object)adapterType)) {
                return FileSystemWorkbenchAdapter.getInstance();
            }
            if (IDeferredWorkbenchAdapter.class.equals((Object)adapterType)) {
                if (adaptableObject instanceof WorkspaceConnectionPoint || adaptableObject instanceof LocalConnectionPoint || adaptableObject instanceof LocalRoot) {
                    return null;
                }
                return FileSystemWorkbenchAdapter.getInstance();
            }
            return null;
        }

        public Class[] getAdapterList() {
            return new Class[]{IWorkbenchAdapter.class, IDeferredWorkbenchAdapter.class};
        }
    }
}

