/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.internal;

import com.aptana.core.logging.IdeLog;
import com.aptana.ide.ui.io.IOUIPlugin;
import com.aptana.ide.ui.io.internal.FetchFileInfoStatus;
import com.aptana.ide.ui.io.internal.Messages;
import java.text.MessageFormat;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class FetchFileInfoJob
extends Job {
    private final IFileStore fileStore;
    private final int options;

    public FetchFileInfoJob(IFileStore fileStore, int options) {
        super(MessageFormat.format(Messages.FetchFileInfoJob_Title, fileStore.toString()));
        this.fileStore = fileStore;
        this.options = options;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IFileInfo fileInfo;
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        try {
            fileInfo = this.fileStore.fetchInfo(this.options, monitor);
        }
        catch (CoreException e) {
            IdeLog.logWarning((Plugin)IOUIPlugin.getDefault(), (String)Messages.FetchFileInfoJob_FailedToFetch, (Throwable)e);
            return e.getStatus();
        }
        return new FetchFileInfoStatus(fileInfo);
    }
}

