/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.actions;

import com.aptana.core.logging.IdeLog;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.ui.io.IOUIPlugin;
import com.aptana.ide.ui.io.actions.ConnectionActionDelegate;
import com.aptana.ide.ui.io.actions.Messages;
import com.aptana.ui.util.UIUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class DeleteConnectionAction
extends ConnectionActionDelegate {
    public void run(IAction action) {
        IConnectionPoint[] connections = this.getSelectedConnectionPoints();
        if (connections.length == 0) {
            return;
        }
        final ArrayList<IConnectionPoint> connectionsToDelete = new ArrayList<IConnectionPoint>();
        IConnectionPoint[] iConnectionPointArray = connections;
        int n = connections.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionPoint connection = iConnectionPointArray[n2];
            if (MessageDialog.openConfirm((Shell)UIUtils.getActiveShell(), (String)Messages.DeleteConnectionAction_Confirm_Title, (String)MessageFormat.format(Messages.DeleteConnectionAction_Confirm_Message, connection))) {
                connectionsToDelete.add(connection);
            }
            ++n2;
        }
        Job job = new Job(Messages.DeleteConnectionAction_DeletingConnections){

            protected IStatus run(IProgressMonitor monitor) {
                for (IConnectionPoint connection : connectionsToDelete) {
                    monitor.subTask(MessageFormat.format(Messages.DeleteConnectionAction_Deleting, connection));
                    CoreIOPlugin.getConnectionPointManager().removeConnectionPoint(connection);
                    if (!connection.canDisconnect()) continue;
                    try {
                        connection.disconnect(monitor);
                    }
                    catch (CoreException e) {
                        IdeLog.logError((Plugin)IOUIPlugin.getDefault(), (String)Messages.DeleteConnectionAction_FailedToDisconnect, (Throwable)e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setPriority(30);
        job.setRule((ISchedulingRule)this.connectionPoint.getAdapter(ISchedulingRule.class));
        job.schedule();
    }
}

