/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageFileNameProvider;

public class DPIUtil {
    private static final int DPI_ZOOM_100 = 96;
    private static int deviceZoom = 100;

    public static int mapDPIToZoom(int dpi) {
        double zoom = (double)dpi * 100.0 / 96.0;
        int roundedZoom = (int)Math.round(zoom);
        return roundedZoom;
    }

    public static ImageData validateAndGetImageDataAtZoom(ImageDataProvider provider, int zoom, boolean[] found) {
        ImageData data;
        if (provider == null) {
            SWT.error(4);
        }
        boolean bl = found[0] = (data = provider.getImageData(zoom)) != null;
        if (zoom != 100 && !found[0]) {
            data = provider.getImageData(100);
        }
        if (data == null) {
            SWT.error(5);
        }
        return data;
    }

    public static String validateAndGetImagePathAtZoom(ImageFileNameProvider provider, int zoom, boolean[] found) {
        String filename;
        if (provider == null) {
            SWT.error(4);
        }
        boolean bl = found[0] = (filename = provider.getImagePath(zoom)) != null;
        if (zoom != 100 && !found[0]) {
            filename = provider.getImagePath(100);
        }
        if (filename == null) {
            SWT.error(5);
        }
        return filename;
    }

    public static int getDeviceZoom() {
        return deviceZoom;
    }

    public static void setDeviceZoom(int nativeDeviceZoom) {
        deviceZoom = nativeDeviceZoom;
        System.setProperty("org.eclipse.swt.internal.deviceZoom", Integer.toString(deviceZoom));
    }

    public static ImageData autoScaleUp(Device device, ImageData imageData) {
        if (deviceZoom <= 100) {
            return imageData;
        }
        ImageData result = imageData;
        try {
            double scale = (double)deviceZoom / 100.0;
            result = result.scaledTo((int)((double)result.width * scale), (int)((double)result.height * scale));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static ImageData autoScaleDown(Device device, ImageData imageData) {
        if (deviceZoom <= 100) {
            return imageData;
        }
        ImageData result = imageData;
        try {
            double scale = (double)deviceZoom / 100.0;
            result = result.scaledTo((int)((double)result.width * scale), (int)((double)result.height * scale));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

