/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.formatter.preferences;

import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.formatter.preferences.Messages;
import com.aptana.formatter.ui.FormatterMessages;
import com.aptana.formatter.ui.IFormatterControlManager;
import com.aptana.formatter.ui.IFormatterModifyDialog;
import com.aptana.formatter.ui.preferences.FormatterModifyTabPage;
import com.aptana.formatter.ui.util.SWTFactory;
import java.net.URL;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class JSFormatterIndentationTabPage
extends FormatterModifyTabPage {
    private static final String INDENTATION_PREVIEW_FILE = "indentation-preview.js";
    private final String[] TAB_OPTION_ITEMS = new String[]{"space", "tab", "editor"};
    private final String[] TAB_OPTION_NAMES = new String[]{FormatterMessages.IndentationTabPage_general_group_option_tab_policy_SPACE, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_TAB, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_EDITOR};

    public JSFormatterIndentationTabPage(IFormatterModifyDialog dialog) {
        super(dialog);
    }

    protected void createOptions(IFormatterControlManager manager, Composite parent) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)Messages.JSFormatterIndentationTabPage_indentationGeneralGroupLabel, (int)2, (int)1, (int)768);
        Combo tabOptions = manager.createCombo((Composite)group, (Object)"js.formatter.formatter.tabulation.char", FormatterMessages.IndentationTabPage_general_group_option_tab_policy, this.TAB_OPTION_ITEMS, this.TAB_OPTION_NAMES);
        Text indentationSize = manager.createNumber((Composite)group, "js.formatter.formatter.indentation.size", FormatterMessages.IndentationTabPage_general_group_option_indent_size, 1);
        new TabOptionHandler(manager, tabOptions, indentationSize);
        group = SWTFactory.createGroup((Composite)parent, (String)"\u6570\u7ec4", (int)1, (int)1, (int)768);
        manager.createCheckbox((Composite)group, (Object)"js.formatter.indent.keep.array.indentation", "\u4fdd\u6301\u6570\u7ec4\u539f\u7f29\u8fdb\u4e0d\u53d8(&K)");
    }

    protected URL getPreviewContent() {
        return ((Object)((Object)this)).getClass().getResource(INDENTATION_PREVIEW_FILE);
    }

    private class TabOptionHandler
    extends SelectionAdapter
    implements IFormatterControlManager.IInitializeListener {
        private IFormatterControlManager manager;
        private Combo tabOptions;
        private Text indentationSize;

        public TabOptionHandler(IFormatterControlManager controlManager, Combo tabOptions, Text indentationSize) {
            this.manager = controlManager;
            this.tabOptions = tabOptions;
            this.indentationSize = indentationSize;
            tabOptions.addSelectionListener((SelectionListener)this);
            this.manager.addInitializeListener((IFormatterControlManager.IInitializeListener)this);
        }

        public void widgetSelected(SelectionEvent e) {
            int index = this.tabOptions.getSelectionIndex();
            if (index >= 0) {
                boolean tabMode = "tab".equals(JSFormatterIndentationTabPage.this.TAB_OPTION_ITEMS[index]);
                boolean editorSettingsMode = "editor".equals(JSFormatterIndentationTabPage.this.TAB_OPTION_ITEMS[index]);
                this.manager.enableControl((Control)this.indentationSize, !tabMode && !editorSettingsMode);
                if (editorSettingsMode) {
                    JSFormatterIndentationTabPage.this.setEditorTabWidth(JSPlugin.getDefault().getBundle().getSymbolicName(), new Text[]{this.indentationSize});
                }
            }
        }

        public void initialize() {
            boolean tabMode = "tab".equals(this.manager.getString((Object)"js.formatter.formatter.tabulation.char"));
            boolean editorSettingsMode = "editor".equals(this.manager.getString((Object)"js.formatter.formatter.tabulation.char"));
            this.manager.enableControl((Control)this.indentationSize, !tabMode && !editorSettingsMode);
            if (editorSettingsMode) {
                JSFormatterIndentationTabPage.this.setEditorTabWidth(JSPlugin.getDefault().getBundle().getSymbolicName(), new Text[]{this.indentationSize});
            }
        }
    }
}

