/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.formatter;

import com.aptana.editor.js.formatter.nodes.FormatterJSCommentNode;
import com.aptana.formatter.FormatterDocument;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.nodes.FormatterNodeRewriter;
import com.aptana.formatter.nodes.IFormatterContainerNode;
import com.aptana.formatter.nodes.IFormatterNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSFormatterNodeRewriter
extends FormatterNodeRewriter {
    private static final Pattern COMMENT_LINE_PATTERN = Pattern.compile("(\\S.*)");
    private static final String MULTI_LINE_COMMENT_PREFIX = "/*";

    public JSFormatterNodeRewriter(IParseRootNode parseResultRoot, FormatterDocument document) {
        IParseNode[] comments = parseResultRoot.getCommentNodes();
        this.insertComments(document, comments);
    }

    private void insertComments(FormatterDocument document, IParseNode[] comments) {
        IParseNode[] iParseNodeArray = comments;
        int n = comments.length;
        int n2 = 0;
        while (n2 < n) {
            int endingOffset;
            IParseNode node = iParseNodeArray[n2];
            int startingOffset = node.getStartingOffset();
            String commentText = document.get(startingOffset, endingOffset = node.getEndingOffset() + 1);
            if (commentText.startsWith(MULTI_LINE_COMMENT_PREFIX)) {
                Matcher matcher = COMMENT_LINE_PATTERN.matcher(commentText);
                boolean isFirstLine = true;
                while (matcher.find()) {
                    int start = matcher.start();
                    int end = matcher.end();
                    this.addComment(startingOffset + start, startingOffset + end, new JSCommentInfo(true, isFirstLine));
                    isFirstLine = false;
                }
            } else {
                this.addComment(startingOffset, endingOffset, new JSCommentInfo(false, false));
            }
            ++n2;
        }
    }

    public void rewrite(IFormatterContainerNode root) {
        super.rewrite(root);
        this.attachComments(root);
    }

    protected IFormatterNode createCommentNode(IFormatterDocument document, int startOffset, int endOffset, Object object) {
        JSCommentInfo info = (JSCommentInfo)object;
        return new FormatterJSCommentNode(document, startOffset, endOffset, info.isMultiLine, info.isFirstLine);
    }

    private class JSCommentInfo {
        boolean isMultiLine;
        boolean isFirstLine;

        JSCommentInfo(boolean isMultiLine, boolean isFirstLine) {
            this.isMultiLine = isMultiLine;
            this.isFirstLine = isFirstLine;
        }
    }
}

