/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.formatter;

import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.JSSourceConfiguration;
import com.aptana.editor.js.JSSourceViewerConfiguration;
import com.aptana.editor.js.formatter.JSFormatter;
import com.aptana.editor.js.formatter.JSFormatterPlugin;
import com.aptana.editor.js.formatter.preferences.JSFormatterModifyDialog;
import com.aptana.formatter.AbstractScriptFormatterFactory;
import com.aptana.formatter.IScriptFormatter;
import com.aptana.formatter.IScriptFormatterFactory;
import com.aptana.formatter.preferences.PreferenceKey;
import com.aptana.formatter.ui.IFormatterModifyDialog;
import com.aptana.formatter.ui.IFormatterModifyDialogOwner;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.texteditor.ITextEditor;

public class JSFormatterFactory
extends AbstractScriptFormatterFactory {
    private static final PreferenceKey FORMATTER_PREF_KEY = new PreferenceKey("com.aptana.editor.js.formatter", "js.formatter");
    private static final String FORMATTER_PREVIEW_FILE = "formatterPreview.js";
    private static final String[] KEYS = new String[]{"js.formatter.formatter.indentation.size", "js.formatter.formatter.tabulation.char", "js.formatter.formatter.tabulation.size", "js.formatter.wrap.comments", "js.formatter.wrap.comments.length", "js.formatter.indent.blocks", "js.formatter.indent.case.body", "js.formatter.indent.switch.body", "js.formatter.indent.function.body", "js.formatter.indent.group.body", "js.formatter.newline.before.catch", "js.formatter.newline.before.dowhile", "js.formatter.newline.before.else", "js.formatter.newline.before.if.in.elseif", "js.formatter.newline.before.finally", "js.formatter.newline.before.name.value.pairs", "js.formatter.line.after.function.declaration.expression", "js.formatter.line.after.function.declaration", "js.formatter.line.preserve", "js.formatter.brace.position.blocks", "js.formatter.brace.position.blocks.preserve.inline", "js.formatter.brace.position.case.block", "js.formatter.brace.position.switch.block", "js.formatter.brace.position.function.declaration", "js.formatter.spaces.before.commas", "js.formatter.spaces.after.commas", "js.formatter.spaces.before.unary.operator", "js.formatter.spaces.after.unary.operator", "js.formatter.spaces.before.key.value.operator", "js.formatter.spaces.after.key.value.operator", "js.formatter.spaces.before.assignment.operator", "js.formatter.spaces.after.assignment.operator", "js.formatter.spaces.before.relational.operator", "js.formatter.spaces.after.relational.operator", "js.formatter.spaces.before.concatenation.operator", "js.formatter.spaces.after.concatenation.operator", "js.formatter.spaces.before.conditional.operator", "js.formatter.spaces.after.conditional.operator", "js.formatter.spaces.before.postfix.operator", "js.formatter.spaces.after.postfix.operator", "js.formatter.spaces.before.prefix.operator", "js.formatter.spaces.after.prefix.operator", "js.formatter.spaces.before.arithmetic.operator", "js.formatter.spaces.after.arithmetic.operator", "js.formatter.spaces.before.for.semicolon.operator", "js.formatter.spaces.after.for.semicolon.operator", "js.formatter.spaces.before.semicolon.operator", "js.formatter.spaces.after.semicolon.operator", "js.formatter.spaces.before.case.colon.operator", "js.formatter.spaces.after.case.colon.operator", "js.formatter.spaces.before.parentheses", "js.formatter.spaces.after.parentheses", "js.formatter.spaces.before.parentheses.closing", "js.formatter.spaces.before.declaration.parentheses.opening", "js.formatter.spaces.after.declaration.parentheses.opening", "js.formatter.spaces.before.declaration.parentheses.closing", "js.formatter.spaces.before.invocation.parentheses.opening", "js.formatter.spaces.after.invocation.parentheses.opening", "js.formatter.spaces.before.invocation.parentheses.closing", "js.formatter.spaces.before.array.access.parentheses.opening", "js.formatter.spaces.after.array.access.parentheses.opening", "js.formatter.spaces.before.array.access.parentheses.closing", "js.formatter.spaces.before.loop.parentheses.opening", "js.formatter.spaces.after.loop.parentheses.opening", "js.formatter.spaces.before.loop.parentheses.closing", "js.formatter.spaces.before.conditional.parentheses.opening", "js.formatter.spaces.after.conditional.parentheses.opening", "js.formatter.spaces.before.conditional.parentheses.closing", "js.formatter.formatter.on.off.enabled", "js.formatter.formatter.on", "js.formatter.formatter.off", "js.formatter.indent.keep.array.indentation", "js.formatter.wrap.length", "js.formatter.wrap.break.chained.methods", "js.formatter.spaces.in.paren", "js.formatter.spaces.in.empty.paren", "js.formatter.spaces.before.conditional", "js.formatter.spaces.after.anon.function"};

    public PreferenceKey[] getPreferenceKeys() {
        PreferenceKey[] result = new PreferenceKey[KEYS.length];
        int i = 0;
        while (i < KEYS.length) {
            String key = KEYS[i];
            result[i] = new PreferenceKey("com.aptana.editor.js.formatter", key);
            ++i;
        }
        return result;
    }

    public IScriptFormatter createFormatter(String lineSeparator, Map<String, String> preferences) {
        return new JSFormatter(lineSeparator, preferences, this.getMainContentType());
    }

    public URL getPreviewContent() {
        return ((Object)((Object)this)).getClass().getResource(FORMATTER_PREVIEW_FILE);
    }

    public IFormatterModifyDialog createDialog(IFormatterModifyDialogOwner dialogOwner) {
        return new JSFormatterModifyDialog(dialogOwner, (IScriptFormatterFactory)this);
    }

    public SourceViewerConfiguration createSimpleSourceViewerConfiguration(ISharedTextColors colorManager, IPreferenceStore preferenceStore, ITextEditor editor, boolean configureFormatter) {
        return new JSSourceViewerConfiguration(preferenceStore, (AbstractThemeableEditor)editor);
    }

    public PreferenceKey getFormatterPreferenceKey() {
        return FORMATTER_PREF_KEY;
    }

    public IPreferenceStore getPreferenceStore() {
        return JSFormatterPlugin.getDefault().getPreferenceStore();
    }

    public Object getPartitioningConfiguration() {
        return JSSourceConfiguration.getDefault();
    }

    protected IEclipsePreferences getEclipsePreferences() {
        return EclipseUtil.instanceScope().getNode("com.aptana.editor.js");
    }

    protected String getFormatterTabPolicy(Map<String, String> preferences) {
        return preferences.get("js.formatter.formatter.tabulation.char");
    }

    protected int getEditorTabSize() {
        return EditorUtil.getSpaceIndentSize((String)JSPlugin.getDefault().getBundle().getSymbolicName());
    }

    protected int getDefaultEditorTabSize() {
        return EditorUtil.getDefaultSpaceIndentSize((String)JSPlugin.getDefault().getBundle().getSymbolicName());
    }

    protected String getFormatterTabSizeKey() {
        return "js.formatter.formatter.tabulation.size";
    }

    public boolean isContributingToUI() {
        return true;
    }
}

