/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.ui.view;

import com.pandora.browser.remote.debug.RemoteDebugClient;
import com.pandora.browser.remote.debug.domain.Page;
import com.pandora.browser.remote.debug.listener.MessageListener;
import com.pandora.core.Platform;
import com.pandora.core.log.HBLog;
import com.pandora.core.utils.IOUtil;
import com.pandora.core.utils.InputStreamRunnable;
import com.pandora.core.utils.Packageutils;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.core.utils.ProjectUtils;
import com.pandora.core.utils.RunInBrowserUtil;
import com.pandora.core.utils.StringUtil;
import com.pandora.core.utils.ThemeUtil;
import com.pandora.core.utils.WorkspaceUtil;
import com.pandora.launcher.core.DefaultMobileManager;
import com.pandora.launcher.core.ILauncher;
import com.pandora.launcher.core.LauncherCoreActivator;
import com.pandora.launcher.core.factory.LauncherFactory;
import com.pandora.launcher.core.internal.Mobile;
import com.pandora.launcher.core.internal.RemoteDebugObject;
import com.pandora.launcher.core.listener.IRemoteDebug;
import com.pandora.launcher.ui.LauncherActivator;
import com.pandora.launcher.ui.view.RemoteDebugJob;
import com.pandora.launcher.ui.view.RemoteDebugObjectUI;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class RemoteDebugView
extends ViewPart
implements IRemoteDebug,
SelectionListener {
    public static final String VIEW_ID = "com.pandora.view.RemoteDebugView";
    private ScrolledComposite fScrolledComposite;
    private Composite fComposite;
    private Composite fparent;
    private Font mTitleFont;
    private Font pTitleFont;
    private static final String REMOTE_DEBUG_OBJECT = "REMOTE_DEBUG_OBJECT";
    private static int CHROME_DEBUG_PORT = 9323;
    public static int DELAY = 5000;
    private static String REMOTE_HTML;
    private RemoteDebugJob remoteDebugJob;
    private boolean isRefresh;
    private boolean autoStart;
    public static boolean isDisposed;
    private static Map<Mobile, RemoteDebugObjectUI> previousRemoteDebugObjectUIs;

    static {
        isDisposed = false;
        previousRemoteDebugObjectUIs = new HashMap<Mobile, RemoteDebugObjectUI>();
    }

    public void createPartControl(Composite parent) {
        isDisposed = false;
        this.fparent = parent;
        this.fScrolledComposite = new ScrolledComposite(this.fparent, 768);
        this.fScrolledComposite.getVerticalBar().setIncrement(10);
        this.remoteDebugJob = new RemoteDebugJob("refresh debug list", this);
        this.remoteDebugJob.setSystem(true);
        this.remoteDebugJob.schedule(1000L);
        this.autoStart = LauncherCoreActivator.isAutoStartWebviewRemoteDebugView();
        this.createContent();
        try {
            REMOTE_HTML = new File(FileLocator.toFileURL((URL)LauncherActivator.getDefault().getBundle().getResource("icons/remote.html")).getFile()).getAbsolutePath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createContent() {
        this.isRefresh = false;
        this.createItems(null);
    }

    private void createItems(List<RemoteDebugObjectUI> remoteDebugObjectUIs) {
        if (this.fComposite != null) {
            this.fComposite.dispose();
        }
        if (this.fScrolledComposite == null || this.fScrolledComposite.isDisposed()) {
            return;
        }
        this.fComposite = new Composite((Composite)this.fScrolledComposite, 0);
        this.fComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().extendedMargins(10, 10, 10, 0).numColumns(1).create());
        this.fScrolledComposite.setContent((Control)this.fComposite);
        this.fScrolledComposite.setBackground(ThemeUtil.getBackgroundColor());
        final Button checkButton = new Button(this.fComposite, 32);
        checkButton.setSelection(this.autoStart);
        checkButton.setFont(this.getPTitleFont());
        checkButton.setForeground(ThemeUtil.getForegroundColor());
        checkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteDebugView.this.autoStart = checkButton.getSelection();
                LauncherCoreActivator.setAutoStartWebviewRemoteDebugView((boolean)RemoteDebugView.this.autoStart);
            }
        });
        checkButton.setText("\u771f\u673a\u8fd0\u884c\u81ea\u52a8\u6253\u5f00WebView\u8c03\u8bd5\u6a21\u5f0f(\u6ce8\uff1a\u5173\u95ed\u540e\u53ef\u5728\u53f3\u4e0a\u89d2\u9009\u62e9\u3010WebView\u8c03\u8bd5\u6a21\u5f0f\u3011\u6253\u5f00\u6b64\u6a21\u5f0f)");
        checkButton.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                gc.setForeground(ThemeUtil.getForegroundColor());
                gc.drawText("\u771f\u673a\u8fd0\u884c\u81ea\u52a8\u6253\u5f00WebView\u8c03\u8bd5\u6a21\u5f0f(\u6ce8\uff1a\u5173\u95ed\u540e\u53ef\u5728\u53f3\u4e0a\u89d2\u9009\u62e9\u3010WebView\u8c03\u8bd5\u6a21\u5f0f\u3011\u6253\u5f00\u6b64\u6a21\u5f0f)", 15, 0, 0x40000008);
            }
        });
        if (PlatformUtil.isMac()) {
            Label pLabel = new Label(this.fComposite, 0);
            pLabel.setText("\u6ce8\uff1aMacOS\u4e0a\u9700\u8981\u5173\u95ed\u5df2\u6253\u5f00\u7684Chrome\u624d\u80fd\u6253\u5f00\u8c03\u8bd5\u9875\u9762\uff01");
            pLabel.setForeground(ThemeUtil.getForegroundColor());
            pLabel.setLayoutData((Object)GridDataFactory.swtDefaults().span(1, 1).create());
        }
        boolean added = false;
        if (remoteDebugObjectUIs != null && remoteDebugObjectUIs.size() > 0) {
            for (RemoteDebugObjectUI remoteDebugObjectUI : remoteDebugObjectUIs) {
                this.createMobileItem(this.fComposite, remoteDebugObjectUI.getMobile(), remoteDebugObjectUI.getRemoteDebugObjects());
                previousRemoteDebugObjectUIs.put(remoteDebugObjectUI.getMobile(), remoteDebugObjectUI);
                added = true;
            }
        }
        if (!added) {
            Link link = new Link(this.fComposite, 0);
            link.setForeground(ThemeUtil.getForegroundColor());
            if (this.isRefresh) {
                link.setText("\u672a\u68c0\u6d4b\u5230\u624b\u673a\uff0c\u8bf7\u63d2\u5165\u624b\u673a\u81f3\u7535\u8111\uff0c\u66f4\u591a\u7591\u95ee\u8bf7\u53c2\u8003\uff1a\r\n<a>\u771f\u673a\u8fd0\u884c\u5e38\u89c1\u6545\u969c\u6392\u9664\u6307\u5357</a>");
                link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Desktop desk = Desktop.getDesktop();
                        try {
                            desk.browse(URI.create("http://ask.dcloud.net.cn/article/97"));
                        }
                        catch (IOException e1) {
                            HBLog.logError((Plugin)LauncherActivator.getDefault(), (Throwable)e1);
                        }
                    }
                });
            } else {
                link.setText("\u6b63\u5728\u68c0\u6d4b\uff0c\u8bf7\u7a0d\u540e\uff01");
            }
        }
        this.fComposite.setSize(this.fComposite.computeSize(-1, -1));
    }

    private List<RemoteDebugObjectUI> getMobileRemoteDebugObjects() {
        ArrayList<RemoteDebugObjectUI> remoteDebugObjectUIs = new ArrayList<RemoteDebugObjectUI>();
        List mobiles = LauncherCoreActivator.getMachineList();
        Mobile currentMobile = DefaultMobileManager.getCurrentMobile();
        try {
            List iOSMobiles = LauncherCoreActivator.getMachineList((Platform)Platform.IPHONE);
            Map iPhoneRemoteDebugObjects = null;
            if (iOSMobiles != null && iOSMobiles.size() > 0) {
                ILauncher iPhoneLauncher = LauncherFactory.buildLauncher((Platform)Platform.IPHONE);
                iPhoneRemoteDebugObjects = iPhoneLauncher.getRemoteDebugUrls(null);
            }
            if (currentMobile != null && mobiles.contains(currentMobile)) {
                if (currentMobile.getPlatform() == Platform.ANDROID) {
                    ILauncher mobileLauncher = LauncherFactory.buildLauncher((Platform)currentMobile.getPlatform());
                    Map remoteDebugObjects = mobileLauncher.getRemoteDebugUrls(currentMobile);
                    remoteDebugObjectUIs.add(new RemoteDebugObjectUI(currentMobile, remoteDebugObjects));
                    mobiles.remove(currentMobile);
                } else {
                    currentMobile.getPlatform();
                }
            }
            for (Mobile mobile : mobiles) {
                try {
                    if (mobile.getPlatform() == Platform.ANDROID) {
                        ILauncher launcher = LauncherFactory.buildLauncher((Platform)mobile.getPlatform());
                        Map remoteDebugObjects = launcher.getRemoteDebugUrls(mobile);
                        remoteDebugObjectUIs.add(new RemoteDebugObjectUI(mobile, remoteDebugObjects));
                        continue;
                    }
                    if (mobile.getPlatform() != Platform.IPHONE) continue;
                    String uuid = mobile.getUuid();
                    if (iPhoneRemoteDebugObjects != null && iPhoneRemoteDebugObjects.containsKey(uuid)) {
                        remoteDebugObjectUIs.add(new RemoteDebugObjectUI(mobile, iPhoneRemoteDebugObjects));
                        continue;
                    }
                    remoteDebugObjectUIs.add(new RemoteDebugObjectUI(mobile, new HashMap<String, List<RemoteDebugObject>>()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return remoteDebugObjectUIs;
    }

    public void createMobileItem(Composite parent, Mobile mobile, Map<String, List<RemoteDebugObject>> remoteDebugObjectsMap) {
        try {
            String mName;
            Composite composite = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().extendedMargins(10, 10, 10, 0).spacing(0, 0).applyTo(composite);
            GridDataFactory.swtDefaults().applyTo((Control)composite);
            String title = mName = mobile.getName();
            if (StringUtil.isNotBlank((String)mobile.getModel())) {
                title = mobile.getModel();
            }
            Label label = new Label(composite, 0);
            label.setForeground(ThemeUtil.getForegroundColor());
            if (!mName.equals(title)) {
                title = String.valueOf(title) + " (" + mName + ")";
            }
            String paltform = "iOS";
            if (mobile.getPlatform() == Platform.ANDROID) {
                paltform = "Android";
            }
            label.setText("\u8bbe\u5907\uff1a" + title + " - " + paltform);
            label.setFont(this.getTitleFont());
            label.setLayoutData((Object)GridDataFactory.swtDefaults().span(1, 1).create());
            Set<String> pids = remoteDebugObjectsMap.keySet();
            String linkMessage = "\u672a\u68c0\u6d4b\u5230\u624b\u673a\u4e0a\u5b58\u5728\u6b63\u5728\u8fd0\u884c\u7684\u8c03\u8bd5\u57fa\u5ea7\u5e94\u7528\uff1a\r\n1\u3001\u624b\u52a8\u8fd0\u884c\u624b\u673a\u4e0a\u7684\u8c03\u8bd5\u5e94\u7528\uff0c\u4f8b\u5982HBuilder\r\n2\u3001\u8fd0\u884c\u81ea\u5b9a\u4e49\u8c03\u8bd5\u57fa\u5ea7\uff0c\u53ef<a>\u70b9\u51fb\u5236\u4f5c</a>\uff0c\u7136\u540e\u8fd0\u884c\u81ea\u5b9a\u4e49\u57fa\u5ea7\r\n3\u3001\u5176\u4ed6\u8bf7\u53c2\u8003<a>WebView\u8c03\u8bd5\u6a21\u5f0f\u5e38\u89c1\u95ee\u9898</a>";
            if (pids == null || pids.size() < 1) {
                new Label(composite, 0).setText(" ");
                Link messageLink = new Link(composite, 0);
                messageLink.setText(linkMessage);
                messageLink.setForeground(ThemeUtil.getForegroundColor());
                messageLink.addSelectionListener((SelectionListener)this);
            }
            for (String pid : pids) {
                String appName;
                List<RemoteDebugObject> remoteDebugObjects = remoteDebugObjectsMap.get(pid);
                if (remoteDebugObjects == null || remoteDebugObjects.size() < 1) {
                    if (mobile.getPlatform() != Platform.IPHONE) continue;
                    new Label(composite, 0).setText(" ");
                    Link messageLink = new Link(composite, 0);
                    messageLink.setText(linkMessage);
                    messageLink.addSelectionListener((SelectionListener)this);
                    messageLink.setForeground(ThemeUtil.getForegroundColor());
                    continue;
                }
                RemoteDebugObject rdo = remoteDebugObjects.get(0);
                String remoteFullPath = rdo.getRemoteFilePath();
                if (StringUtil.isBlank((String)remoteFullPath)) continue;
                if (mobile.getPlatform() == Platform.ANDROID) {
                    Label pLabel = new Label(composite, 0);
                    String prefix = "/Android/data/";
                    int index = remoteFullPath.indexOf(prefix);
                    String packageName = "Unknow";
                    if (index > 0) {
                        packageName = remoteFullPath.substring(index + prefix.length());
                        packageName = packageName.substring(0, packageName.indexOf("/"));
                    }
                    if (StringUtil.isNotBlank((String)(appName = rdo.getAppName()))) {
                        pLabel.setText("WebView in " + packageName + " - " + appName);
                    } else {
                        pLabel.setText("WebView in " + packageName);
                    }
                    pLabel.setFont(this.getPTitleFont());
                    pLabel.setForeground(ThemeUtil.getForegroundColor());
                    pLabel.setLayoutData((Object)GridDataFactory.swtDefaults().span(1, 1).create());
                    new Label(composite, 0).setText(" ");
                }
                String appName_ = null;
                String other = "\u5176\u4ed6";
                for (RemoteDebugObject remoteDebugObject : remoteDebugObjects) {
                    String remotePath;
                    appName = remoteDebugObject.getAppName();
                    if ((StringUtil.isBlank(appName_) || !appName_.equals(appName) && (!appName_.equals(other) || StringUtil.isNotBlank((String)appName))) && mobile.getPlatform() == Platform.IPHONE) {
                        new Label(composite, 0).setText(" ");
                        Label pLabel = new Label(composite, 0);
                        if (StringUtil.isNotBlank((String)appName)) {
                            appName_ = appName;
                            pLabel.setText("appid\uff1a" + appName);
                        } else {
                            appName_ = other;
                            pLabel.setText(other);
                        }
                        pLabel.setFont(this.getPTitleFont());
                        pLabel.setForeground(ThemeUtil.getForegroundColor());
                        pLabel.setLayoutData((Object)GridDataFactory.swtDefaults().span(1, 1).create());
                    }
                    String string = remotePath = StringUtil.isNotBlank((String)remoteDebugObject.getAppName()) && StringUtil.isNotBlank((String)remoteDebugObject.getFilePath()) ? remoteDebugObject.getFilePath() : remoteDebugObject.getRemoteFilePath();
                    if (StringUtil.isBlank((String)remotePath)) continue;
                    Link link = new Link(composite, 64);
                    String rdoTitle = remoteDebugObject.getTitle();
                    if (StringUtil.isNotBlank((String)rdoTitle) && rdoTitle.startsWith("file:///")) {
                        link.setText(String.valueOf(remotePath) + "\r\n<a>inspect(\u8c03\u8bd5)</a>");
                    } else if (StringUtil.isNotBlank((String)rdoTitle)) {
                        link.setText(String.valueOf(remoteDebugObject.getTitle()) + " - " + remotePath + "\r\n<a>inspect(\u8c03\u8bd5)</a>");
                    } else {
                        link.setText(String.valueOf(remotePath) + "\r\n<a>inspect(\u8c03\u8bd5)</a>");
                    }
                    link.setForeground(ThemeUtil.getForegroundColor());
                    link.setToolTipText(remotePath);
                    link.setData(REMOTE_DEBUG_OBJECT, (Object)remoteDebugObject);
                    if (StringUtil.isBlank((String)remoteDebugObject.getUri())) {
                        link.setEnabled(false);
                    }
                    link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            Link source = (Link)e.getSource();
                            RemoteDebugObject rdo = (RemoteDebugObject)source.getData(RemoteDebugView.REMOTE_DEBUG_OBJECT);
                            String uri = rdo.getUri();
                            if (StringUtil.isBlank((String)uri)) {
                                MessageDialog.openWarning((Shell)source.getShell(), (String)"\u63d0\u793a", (String)"\u8c03\u8bd5\u9875\u9762\u662f\u5426\u5df2\u6253\u5f00\uff0c\u8bf7\u5173\u95ed\u540e\u518d\u91cd\u8bd5\uff01");
                                return;
                            }
                            RemoteDebugView.this.openRemoteDebug(rdo);
                            super.widgetSelected(e);
                        }
                    });
                }
                new Label(composite, 0).setText(" ");
            }
        }
        catch (Exception e) {
            HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (Throwable)e);
        }
    }

    private Font getTitleFont() {
        if (this.mTitleFont == null) {
            Font dFont = JFaceResources.getDefaultFont();
            FontData fd = dFont.getFontData()[0];
            this.mTitleFont = new Font((Device)this.fparent.getDisplay(), fd.getName(), fd.getHeight() + 2, 0);
        }
        return this.mTitleFont;
    }

    private Font getPTitleFont() {
        if (this.pTitleFont == null) {
            Font dFont = JFaceResources.getDefaultFont();
            FontData fd = dFont.getFontData()[0];
            this.pTitleFont = new Font((Device)this.fparent.getDisplay(), fd.getName(), fd.getHeight(), 1);
        }
        return this.pTitleFont;
    }

    public void dispose() {
        IPerspectiveDescriptor web;
        IPerspectiveDescriptor pd;
        IWorkbenchPage page;
        IWorkbenchWindow win;
        isDisposed = true;
        if (this.fComposite != null) {
            this.fComposite.dispose();
            this.fComposite = null;
        }
        if (this.fScrolledComposite != null) {
            this.fScrolledComposite.dispose();
            this.fScrolledComposite = null;
        }
        if (this.mTitleFont != null) {
            this.mTitleFont.dispose();
            this.mTitleFont = null;
        }
        if (this.remoteDebugJob != null) {
            this.remoteDebugJob.cancel();
            this.remoteDebugJob = null;
        }
        if ((win = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (page = win.getActivePage()) != null && (pd = page.getPerspective()) != null && "com.pandora.view.RemoteDebugPerspective".equals(pd.getId()) && (web = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId("com.aptana.ui.WebPerspective")) != null) {
            page.setPerspective(web);
        }
        if (previousRemoteDebugObjectUIs != null) {
            previousRemoteDebugObjectUIs.clear();
        }
        super.dispose();
    }

    public void setFocus() {
    }

    public void openRemoteDebug(final RemoteDebugObject rdo) {
        LauncherCoreActivator.chromeDebugThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String chromePath = RunInBrowserUtil.getChromeBroswerLocation();
                    if (StringUtil.isBlank((String)chromePath)) {
                        return;
                    }
                    String debugDataDir = String.valueOf(WorkspaceUtil.getUserProfilesDir()) + "ChromeDebugData";
                    File file = new File(debugDataDir);
                    if (!file.exists() || !file.isDirectory()) {
                        file.mkdirs();
                    }
                    ArrayList<String> args = new ArrayList<String>();
                    if (PlatformUtil.isMac()) {
                        args.add("/usr/bin/open");
                        args.add("-a");
                        args.add(chromePath);
                        args.add("--args");
                    } else {
                        args.add("CMD");
                        args.add("/C");
                        args.add(chromePath);
                    }
                    args.add("--app=" + REMOTE_HTML);
                    args.add("--user-data-dir=" + debugDataDir);
                    CHROME_DEBUG_PORT = IOUtil.findFreePort((int)CHROME_DEBUG_PORT);
                    args.add("--remote-debugging-port=" + CHROME_DEBUG_PORT);
                    ProcessBuilder pb = new ProcessBuilder(new String[0]);
                    pb.command(args.toArray(new String[args.size()]));
                    pb.redirectErrorStream(true);
                    LauncherCoreActivator.chromeDebugProcess = pb.start();
                    LauncherCoreActivator.chromeDebugProcess.getOutputStream().flush();
                    LauncherCoreActivator.chromeDebugProcess.getOutputStream().close();
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread t = new Thread((Runnable)new InputStreamRunnable(LauncherCoreActivator.chromeDebugProcess.getErrorStream(), "remoteDebugging Error"));
                                t.start();
                                InputStream is = LauncherCoreActivator.chromeDebugProcess.getInputStream();
                                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                                while (reader.read() != -1) {
                                    reader.readLine();
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }).start();
                    RemoteDebugClient rdc = new RemoteDebugClient();
                    Thread.sleep(3000L);
                    boolean connected = false;
                    int i = 0;
                    while (!connected) {
                        if (i < 10) {
                            try {
                                connected = rdc.connect(CHROME_DEBUG_PORT);
                                if (connected) {
                                    break;
                                }
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                                Thread.sleep(1000L);
                            }
                            ++i;
                            continue;
                        }
                        HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (String)"Chrome\u8c03\u8bd5\u542f\u52a8\u5931\u8d25:\n1\u3001\u8bf7\u5173\u95ed\u5df2\u6253\u5f00\u7684Chrome\n2\u3001\u786e\u8ba4Chrome\u8def\u5f84\u914d\u7f6e\u662f\u5426\u6b63\u786e\n3\u3001\u91cd\u65b0\u8fd0\u884c\u8c03\u8bd5");
                        return;
                    }
                    Thread.sleep(1000L);
                    Page page = rdc.getPage();
                    page.navigate(rdo.getUri(), new MessageListener(){

                        public void receive(JSONObject response) {
                        }
                    });
                }
                catch (Exception e1) {
                    HBLog.logError((Plugin)LauncherCoreActivator.getDefault(), (Throwable)e1);
                }
            }
        });
        LauncherCoreActivator.chromeDebugThread.start();
    }

    public void refresh() {
        final List<RemoteDebugObjectUI> remoteDebugObjectUIs = this.getMobileRemoteDebugObjects();
        if (this.checkRefresh(remoteDebugObjectUIs)) {
            previousRemoteDebugObjectUIs.clear();
            this.isRefresh = true;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    RemoteDebugView.this.createItems(remoteDebugObjectUIs);
                }
            });
        }
    }

    private boolean checkRefresh(List<RemoteDebugObjectUI> remoteDebugObjectUIs) {
        if (previousRemoteDebugObjectUIs == null || previousRemoteDebugObjectUIs.size() < 1) {
            return true;
        }
        if (previousRemoteDebugObjectUIs.size() != remoteDebugObjectUIs.size()) {
            return true;
        }
        for (RemoteDebugObjectUI remoteDebugObjectUI : remoteDebugObjectUIs) {
            Mobile mobile = remoteDebugObjectUI.getMobile();
            if (!previousRemoteDebugObjectUIs.containsKey(mobile)) {
                return true;
            }
            Map<String, List<RemoteDebugObject>> remoteDebugObjectMap = remoteDebugObjectUI.getRemoteDebugObjects();
            RemoteDebugObjectUI pRemoteDebugObjectUI = previousRemoteDebugObjectUIs.get(mobile);
            Map<String, List<RemoteDebugObject>> pRemoteDebugObjectMap = pRemoteDebugObjectUI.getRemoteDebugObjects();
            if (remoteDebugObjectMap != null && pRemoteDebugObjectMap != null && remoteDebugObjectMap.size() != pRemoteDebugObjectMap.size()) {
                return true;
            }
            Set<String> keys = remoteDebugObjectMap.keySet();
            Set<String> pkeys = pRemoteDebugObjectMap.keySet();
            for (String key : keys) {
                if (pkeys.contains(key)) continue;
                return true;
            }
            for (String key : keys) {
                List<RemoteDebugObject> remoteDebugObjects = remoteDebugObjectMap.get(key);
                List<RemoteDebugObject> pRemoteDebugObjects = pRemoteDebugObjectMap.get(key);
                if (remoteDebugObjects != null && pRemoteDebugObjects != null && remoteDebugObjects.size() != pRemoteDebugObjects.size()) {
                    return true;
                }
                for (RemoteDebugObject remoteDebugObject : remoteDebugObjects) {
                    if (pRemoteDebugObjects.contains(remoteDebugObject)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void widgetSelected(SelectionEvent e) {
        String text = e.text;
        try {
            if (text.contains("WebView")) {
                Desktop desk = Desktop.getDesktop();
                desk.browse(URI.create("https://ask.dcloud.net.cn/article/12722"));
            } else {
                Packageutils.openMakePackageDialog((Shell)e.widget.getDisplay().getActiveShell(), (IProject)ProjectUtils.getCurrentProject(), (boolean)true);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

