/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.ui;

import com.pandora.launcher.ui.Messages;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

public class HMobileApplicationTab
extends AbstractLaunchConfigurationTab
implements SelectionListener,
ModifyListener {
    private String oldIPAddress = "127.0.0.1";
    private static final String DEFAULT_IP = "127.0.0.1";
    private Combo combo = null;
    private String[] ipItems = new String[]{"127.0.0.1"};

    public HMobileApplicationTab() {
        this.initLocalIPAddress();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Group group = new Group(composite, 0);
        group.setText(Messages.HMobileApplicationTab_MacAddress);
        group.setBounds(10, 20, 430, 68);
        this.combo = new Combo((Composite)group, 0);
        this.combo.setBounds(111, 26, 309, 25);
        this.combo.setItems(this.ipItems);
        this.combo.setText(this.oldIPAddress);
        this.combo.addSelectionListener((SelectionListener)this);
        this.combo.addModifyListener((ModifyListener)this);
        Label lblip = new Label((Composite)group, 0);
        lblip.setBounds(10, 29, 95, 17);
        lblip.setText(Messages.HMobileApplicationTab_SelectIP);
        this.setControl((Control)composite);
    }

    private void initLocalIPAddress() {
        HashSet<String> list = new HashSet<String>();
        list.add(DEFAULT_IP);
        Enumeration<NetworkInterface> netInterfaces = null;
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> ips = ni.getInetAddresses();
                while (ips.hasMoreElements()) {
                    InetAddress address = ips.nextElement();
                    if (address.getHostAddress().indexOf(".") <= 0) continue;
                    list.add(address.getHostAddress());
                    if (DEFAULT_IP.equals(address.getHostAddress())) continue;
                    this.oldIPAddress = address.getHostAddress();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ipItems = list.toArray(new String[list.size()]);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.initLocalIPAddress();
        configuration.setAttribute("IPAddress", this.oldIPAddress);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.oldIPAddress = configuration.getAttribute("IPAddress", this.oldIPAddress);
            this.combo.setText(this.oldIPAddress);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.oldIPAddress = this.combo.getText();
        configuration.setAttribute("IPAddress", this.oldIPAddress);
    }

    public String getName() {
        return Messages.HMobileApplicationTab_LauncherConfig;
    }

    public void widgetSelected(SelectionEvent e) {
        if (!this.oldIPAddress.equals(this.combo.getText())) {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public boolean canSave() {
        return this.isDirty();
    }

    public void modifyText(ModifyEvent e) {
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }
}

