/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.launcher.ui;

import com.pandora.core.log.HBLog;
import com.pandora.core.utils.LocalDirHyperLink;
import com.pandora.core.utils.StringUtil;
import com.pandora.core.utils.URLHyperLink;
import com.pandora.launcher.core.HMobileDeviceLauncher;
import com.pandora.launcher.ui.LauncherActivator;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListenerDelegate;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ConsoleTracker
implements IPatternMatchListenerDelegate {
    private Pattern pattern = Pattern.compile("(file\\sname:(.*)\\r?\\n?line\\sno:(\\d+))|(at\\s(.*):(\\d+))|(\u624b\u52a8\u5b89\u88c5(.*)\u5230\u624b\u673a\u4e0a)|(Chrome\u63a7\u5236\u53f0\u8c03\u8bd5Android\u5e94\u7528\u8bf7\u53c2\u8003\uff1a(.*))|(\u6ce8\uff1a\u68c0\u6d4b\u5230\u5f53\u524d\u4f7f\u7528\u7684ADB\u4e0d\u662fHBuilder\u5185\u7f6e\u6216(.*)\uff1a)|(\u5982\u679c\u9047\u5230\u5f02\u5e38\u60c5\u51b5\uff0c\u70b9\u51fb(.*)\u3002)");
    private TextConsole console;

    public void connect(TextConsole console) {
        this.console = console;
    }

    public void disconnect() {
        this.console = null;
    }

    public void matchFound(PatternMatchEvent event) {
        if (this.console != null) {
            try {
                String text;
                Matcher m;
                ProcessConsole processConsole;
                String project;
                if (event.getSource() instanceof ProcessConsole && StringUtil.isNotBlank((String)(project = (processConsole = (ProcessConsole)event.getSource()).getProcess().getAttribute(HMobileDeviceLauncher.ATTR_PROJECT))) && (m = this.pattern.matcher(text = this.console.getDocument().get(event.getOffset(), event.getLength()))).find()) {
                    String chromeDebugUrl;
                    File file;
                    String packagePath;
                    IFile file2;
                    String filename = m.group(2);
                    String line = m.group(3);
                    if (StringUtil.isBlank((String)filename)) {
                        filename = m.group(5);
                        line = m.group(6);
                    }
                    if (filename != null && line != null && (file2 = ResourcesPlugin.getWorkspace().getRoot().getProject(project).getFile(filename)) != null && file2.exists()) {
                        int lineNum = Integer.parseInt(line);
                        this.console.addHyperlink((IHyperlink)new FileLink(file2, null, -1, -1, lineNum), event.getOffset(), event.getLength());
                    }
                    if (StringUtil.isNotBlank((String)(packagePath = m.group(8))) && (file = new File(packagePath)).exists()) {
                        this.console.addHyperlink((IHyperlink)new LocalDirHyperLink(file), event.getOffset() + text.indexOf(packagePath), packagePath.length());
                    }
                    if (StringUtil.isNotBlank((String)(chromeDebugUrl = m.group(10)))) {
                        this.console.addHyperlink((IHyperlink)new URLHyperLink("http://ask.dcloud.net.cn/article/69"), event.getOffset() + text.indexOf(chromeDebugUrl), chromeDebugUrl.length());
                    }
                    if (StringUtil.isNotBlank((String)(chromeDebugUrl = m.group(12)))) {
                        this.console.addHyperlink(new IHyperlink(){

                            public void linkEntered() {
                            }

                            public void linkExited() {
                            }

                            public void linkActivated() {
                                String[] displayIds = new String[]{"com.aptana.ui.AptanaPreferencePage"};
                                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)Display.getCurrent().getActiveShell(), (String)"com.aptana.ui.AptanaPreferencePage", (String[])displayIds, null);
                                dialog.open();
                            }
                        }, event.getOffset() + text.indexOf(chromeDebugUrl), chromeDebugUrl.length());
                    }
                    if (StringUtil.isNotBlank((String)(chromeDebugUrl = m.group(14)))) {
                        this.console.addHyperlink((IHyperlink)new URLHyperLink("http://ask.dcloud.net.cn/article/97#checkAdb"), event.getOffset() + text.indexOf(chromeDebugUrl), chromeDebugUrl.length());
                    }
                }
            }
            catch (Throwable e) {
                HBLog.logError((Plugin)LauncherActivator.getDefault(), (Throwable)e);
            }
        }
    }
}

