/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.findbar.impl;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.findbar.FindBarPlugin;
import com.aptana.editor.findbar.impl.FindBarDecorator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;

public class FindBarVisibilityControl {
    private final Set<FindBarDecorator> decs = new HashSet<FindBarDecorator>();
    private boolean visible = false;

    public void register(FindBarDecorator findBarDecorator) {
        if (this.visible) {
            findBarDecorator.showFindBar(false);
        }
        this.decs.add(findBarDecorator);
    }

    public void unregister(FindBarDecorator findBarDecorator) {
        this.decs.remove(findBarDecorator);
    }

    public void setVisible(boolean enable, FindBarDecorator requester, String selectedFindText) {
        try {
            if (enable) {
                if (!this.visible) {
                    FindBarDecorator.updateFromEclipseFindSettings();
                }
                if (selectedFindText != null) {
                    requester.setFindText(selectedFindText);
                }
                for (FindBarDecorator d : this.decs) {
                    try {
                        d.showFindBar(d == requester);
                    }
                    catch (Throwable e) {
                        IdeLog.logError((Plugin)FindBarPlugin.getDefault(), (Throwable)e);
                    }
                }
            } else {
                for (FindBarDecorator d : this.decs) {
                    try {
                        d.hideFindBar(d == requester);
                    }
                    catch (Throwable e) {
                        IdeLog.logError((Plugin)FindBarPlugin.getDefault(), (Throwable)e);
                    }
                }
            }
        }
        finally {
            this.visible = enable;
        }
    }
}

