/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.index.store;

import com.aptana.editor.css.contentassist.index.CSSFileIndexingParticipant;
import com.aptana.editor.html.contentassist.index.HTMLFileIndexingParticipant;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.contentassist.index.JSIndexCacher;
import com.aptana.editor.js.contentassist.model.TypeElement;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.RemoteIndexProcessStateHelper;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.pandora.core.log.HBLog;
import com.pandora.core.utils.CollectionsUtil;
import com.pandora.index.service.ILocalIndexService;
import com.pandora.index.service.IndexRequest;
import com.pandora.index.store.IndexStoreActivator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;

public class IndexStoreService
extends UnicastRemoteObject
implements ILocalIndexService {
    private static final long serialVersionUID = -4933184430605382648L;
    private static Kryo kryo = new Kryo();

    static {
        kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
        kryo.setAutoReset(true);
    }

    protected IndexStoreService() throws RemoteException {
    }

    public void ping() throws RemoteException {
        RemoteIndexProcessStateHelper.setState((int)1);
    }

    public void submitIndex(IndexRequest request, Map<String, Set<String>> indexResult) throws RemoteException {
        try {
            if (indexResult != null && !indexResult.isEmpty()) {
                CSSFileIndexingParticipant cssFileIndexingParticipant = new CSSFileIndexingParticipant();
                cssFileIndexingParticipant.setIndexResult(indexResult);
                cssFileIndexingParticipant.saveIndex(request, IndexPlugin.getDefault().getIndexManager().getIndex(request.getProjectURI()));
            }
        }
        catch (Exception e) {
            HBLog.logError((Plugin)IndexStoreActivator.getDefault(), (Throwable)e);
        }
    }

    public byte[] loadJavaScriptIndex(URI indexURI) throws RemoteException {
        if (indexURI != null) {
            if ("metadata:/js".equals(indexURI.toString()) && !JSIndexCacher.getInstance().isExistCache("metadata:/js")) {
                JSPlugin.getDefault().waitingForJavascriptMetadata();
            }
            if (this.getCacher().containsKey(indexURI.toString())) {
                Map<String, Map<String, TypeElement>> index = this.getCacher().get(indexURI.toString());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Output out = new Output((OutputStream)baos);
                kryo.writeClassAndObject(out, index);
                out.close();
                return baos.toByteArray();
            }
        }
        return null;
    }

    public Map<String, Map<String, Map<String, TypeElement>>> getCacher() {
        return JSIndexCacher.getInstance().getCacher();
    }

    public void submitJavaScript(IndexRequest request, byte[] indexContents) throws RemoteException {
        if (indexContents == null) {
            return;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(indexContents);
        Input input = new Input((InputStream)bais);
        Object obj = kryo.readClassAndObject(input);
        if (obj instanceof List) {
            JSIndexCacher.getInstance().addIndexCache(Index.getSimpleIndex((URI)request.getProjectURI()), request.getIndexURI().toString(), (List)obj);
            JSIndexCacher.getInstance().flushProposal(Index.getSimpleIndex((URI)request.getProjectURI()), request.getIndexURI());
        }
    }

    public void autoCheckAndBuildSDOCML(IndexRequest request, String jsSource) {
        try {
            HTMLFileIndexingParticipant htmlFileIndexingParticipant = new HTMLFileIndexingParticipant();
            htmlFileIndexingParticipant.autoCheckAndBuildSDOCML(jsSource, request);
        }
        catch (Exception e) {
            HBLog.logError((Plugin)IndexStoreActivator.getDefault(), (Throwable)e);
        }
    }

    public Set<String> queryDocumentNames(URI projectURI, URI indexURI) throws RemoteException {
        JSIndexCacher cacher;
        Map projectIndex;
        block4: {
            try {
                if (indexURI != null && projectURI != null) break block4;
                return null;
            }
            catch (IOException e) {
                HBLog.logError((Plugin)IndexStoreActivator.getDefault(), (Throwable)e);
                return null;
            }
        }
        String filePath = indexURI.toString();
        Index index = IndexPlugin.getDefault().getIndexManager().getIndex(projectURI);
        HashSet<String> result = index.queryDocumentNames(filePath);
        if (CollectionsUtil.isEmpty((Collection)result) && (projectIndex = (Map)(cacher = JSIndexCacher.getInstance()).getCacher().get(projectURI.toString())) != null && projectIndex.containsKey(filePath)) {
            result = new HashSet<String>();
            result.add(filePath);
        }
        return result;
    }

    public void deleteFileIndex(IndexRequest request) throws RemoteException {
        try {
            Index index = IndexPlugin.getDefault().getIndexManager().getIndex(request.getProjectURI());
            if (index == null) {
                return;
            }
            index.remove(request.getIndexURI());
        }
        catch (Exception e) {
            HBLog.logError((Plugin)IndexStoreActivator.getDefault(), (Throwable)e);
        }
    }
}

