/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui;

import com.aptana.core.ShellExecutable;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.projects.templates.TemplateType;
import com.aptana.ruby.ui.wizards.NewRubyProjectWizard;
import com.aptana.ruby.ui.wizards.WizardNewRubyProjectCreationPage;
import com.aptana.webserver.core.IServer;
import com.aptana.webserver.core.IServerManager;
import com.aptana.webserver.core.WebServerCorePlugin;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.progress.UIJob;
import org.radrails.rails.core.RailsCorePlugin;
import org.radrails.rails.core.RailsServer;
import org.radrails.rails.internal.ui.Messages;
import org.radrails.rails.internal.ui.WizardNewRailsProjectCreationPage;
import org.radrails.rails.ui.RailsUIPlugin;

public class NewRailsProjectWizard
extends NewRubyProjectWizard {
    private boolean runGenerator;

    protected WizardNewRubyProjectCreationPage createMainPage() {
        WizardNewRailsProjectCreationPage mainPage = new WizardNewRailsProjectCreationPage("basicNewProjectPage", this.selectedTemplate);
        mainPage.setTitle(Messages.NewProject_title);
        mainPage.setDescription(Messages.NewRailsProject_description);
        return mainPage;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setWindowTitle(Messages.NewRailsProject_windowTitle);
    }

    protected String[] getProjectNatures() {
        return new String[]{"org.radrails.rails.core.railsnature", "com.aptana.ruby.core.rubynature"};
    }

    protected TemplateType[] getProjectTemplateTypes() {
        return new TemplateType[]{TemplateType.RAILS};
    }

    protected String getProjectCreateEventName() {
        return "project.create.rails";
    }

    public boolean performFinish() {
        IWizardPage page = this.getStartingPage();
        this.runGenerator = false;
        if (page instanceof WizardNewRailsProjectCreationPage) {
            WizardNewRailsProjectCreationPage railsPage = (WizardNewRailsProjectCreationPage)page;
            this.runGenerator = railsPage.runGenerator();
        }
        return super.performFinish();
    }

    protected IProject createNewProject(IProgressMonitor monitor) throws InvocationTargetException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IProject project = super.createNewProject((IProgressMonitor)sub.newChild(90));
        if (this.runGenerator) {
            this.runGenerator((IProgressMonitor)sub.newChild(10));
        }
        return project;
    }

    private void runGenerator(IProgressMonitor monitor) {
        IProject project = this.newProject;
        File projectFile = project.getLocation().toFile();
        File env = new File(projectFile, "config" + File.separator + "environment.rb");
        if (env.exists() && !MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.NewProjectWizard_ContentsAlreadyExist_Title, (String)Messages.NewProjectWizard_ContentsAlreadyExist_Msg)) {
            return;
        }
        this.addServer(project);
        UIJob job = new UIJob(Messages.NewProjectWizard_JobTitle){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                if (subMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setPriority(20);
        job.schedule();
    }

    protected void addServer(IProject project) {
        try {
            IServerManager serverManager = this.getServerManager();
            RailsServer server = (RailsServer)serverManager.createServer("org.radrails.rails.railsServer");
            server.setProject(project);
            server.setName(project.getName());
            serverManager.add((IServer)server);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)RailsUIPlugin.getDefault(), (String)"Error adding server for Rails project", (Throwable)e);
        }
    }

    protected IServerManager getServerManager() {
        return WebServerCorePlugin.getDefault().getServerManager();
    }

    protected boolean requiresNewArgToGenerateApp(IProject project) {
        IStatus result;
        Map env = null;
        if (!"win32".equals(Platform.getOS())) {
            env = ShellExecutable.getEnvironment();
        }
        if ((result = RailsCorePlugin.runRailsInBackground((IPath)project.getLocation(), (Map)env, (String[])new String[]{"-v"})) == null || !result.isOK()) {
            return false;
        }
        String version = result.getMessage();
        String[] parts = version.split("\\s");
        String lastPart = parts[parts.length - 1];
        if (lastPart.startsWith("1") || lastPart.startsWith("2")) {
            return false;
        }
        if (lastPart.startsWith("3.0.0beta")) {
            return lastPart.endsWith("beta4");
        }
        return true;
    }
}

