/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.json.parsing;

import beaver.Scanner;
import beaver.Symbol;
import com.aptana.editor.json.JSONSourceScanner;
import com.aptana.editor.json.parsing.lexer.JSONTokenType;
import java.io.IOException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class JSONScanner
extends Scanner {
    private JSONParserScanner _sourceScanner = new JSONParserScanner();
    private IDocument _document;

    protected Symbol createSymbol(Object data) throws Scanner.Exception {
        int offset = this._sourceScanner.getTokenOffset();
        int length = this._sourceScanner.getTokenLength();
        JSONTokenType type = data == null ? JSONTokenType.EOF : (JSONTokenType)((Object)data);
        try {
            int totalLength = this._document.getLength();
            if (offset > totalLength) {
                offset = totalLength;
            }
            if (length == -1) {
                length = 0;
            }
            return new Symbol(type.getIndex(), offset, offset + length - 1, (Object)this._document.get(offset, length));
        }
        catch (BadLocationException e) {
            throw new Scanner.Exception(e.getLocalizedMessage());
        }
    }

    protected boolean isComment(Object data) {
        return data != null && (JSONTokenType)((Object)data) == JSONTokenType.COMMENT;
    }

    public Symbol nextToken() throws IOException, Scanner.Exception {
        IToken token = this._sourceScanner.nextToken();
        Object data = token.getData();
        while (token.isWhitespace() || this.isComment(data)) {
            token = this._sourceScanner.nextToken();
            data = token.getData();
        }
        return this.createSymbol(data);
    }

    public void setSource(IDocument document) {
        this._document = document;
        this._sourceScanner.setRange(document, 0, document.getLength());
    }

    public void setSource(String text) {
        this.setSource((IDocument)new Document(text));
    }

    private static class JSONParserScanner
    extends JSONSourceScanner {
        private JSONParserScanner() {
        }

        @Override
        protected IToken createToken(JSONTokenType type) {
            return new Token((Object)type);
        }
    }
}

