/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.json.formatter;

import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.json.JSONPlugin;
import com.aptana.editor.json.JSONSourceConfiguration;
import com.aptana.editor.json.JSONSourceViewerConfiguration;
import com.aptana.editor.json.formatter.JSONFormatter;
import com.aptana.editor.json.preferences.JSONFormatterModifyDialog;
import com.aptana.formatter.AbstractScriptFormatterFactory;
import com.aptana.formatter.IScriptFormatter;
import com.aptana.formatter.IScriptFormatterFactory;
import com.aptana.formatter.preferences.PreferenceKey;
import com.aptana.formatter.ui.IFormatterModifyDialog;
import com.aptana.formatter.ui.IFormatterModifyDialogOwner;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.texteditor.ITextEditor;

public class JSONFormatterFactory
extends AbstractScriptFormatterFactory {
    private static final PreferenceKey FORMATTER_PREF_KEY = new PreferenceKey("com.aptana.editor.json", "json.formatter");
    private static final String FORMATTER_PREVIEW_FILE = "formatting-preview.json";
    private static final PreferenceKey[] KEYS = new PreferenceKey[]{new PreferenceKey("com.aptana.editor.json", "json.formatter.formatter.indentation.size"), new PreferenceKey("com.aptana.editor.json", "json.formatter.formatter.tabulation.char"), new PreferenceKey("com.aptana.editor.json", "json.formatter.formatter.tabulation.size")};

    public IFormatterModifyDialog createDialog(IFormatterModifyDialogOwner dialogOwner) {
        return new JSONFormatterModifyDialog(dialogOwner, (IScriptFormatterFactory)this);
    }

    public IScriptFormatter createFormatter(String lineSeparator, Map<String, String> preferences) {
        return new JSONFormatter(lineSeparator, preferences, this.getMainContentType());
    }

    public SourceViewerConfiguration createSimpleSourceViewerConfiguration(ISharedTextColors colorManager, IPreferenceStore preferenceStore, ITextEditor editor, boolean configureFormatter) {
        return new JSONSourceViewerConfiguration(preferenceStore, (AbstractThemeableEditor)editor);
    }

    public PreferenceKey getFormatterPreferenceKey() {
        return FORMATTER_PREF_KEY;
    }

    public PreferenceKey[] getPreferenceKeys() {
        return KEYS;
    }

    public IPreferenceStore getPreferenceStore() {
        return JSONPlugin.getDefault().getPreferenceStore();
    }

    public URL getPreviewContent() {
        return ((Object)((Object)this)).getClass().getResource(FORMATTER_PREVIEW_FILE);
    }

    public Object getPartitioningConfiguration() {
        return JSONSourceConfiguration.getDefault();
    }

    protected IEclipsePreferences getEclipsePreferences() {
        return EclipseUtil.instanceScope().getNode("com.aptana.editor.json");
    }

    protected String getFormatterTabPolicy(Map<String, String> preferences) {
        return preferences.get("json.formatter.formatter.tabulation.char");
    }

    protected int getEditorTabSize() {
        return EditorUtil.getSpaceIndentSize((String)JSONPlugin.getDefault().getBundle().getSymbolicName());
    }

    protected int getDefaultEditorTabSize() {
        return EditorUtil.getDefaultSpaceIndentSize((String)JSONPlugin.getDefault().getBundle().getSymbolicName());
    }

    protected String getFormatterTabSizeKey() {
        return "json.formatter.formatter.tabulation.size";
    }
}

