/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.json.formatter;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.json.JSONPlugin;
import com.aptana.editor.json.formatter.JSONFormatterContext;
import com.aptana.editor.json.formatter.JSONFormatterNodeBuilder;
import com.aptana.editor.json.formatter.JSONFormatterNodeRewriter;
import com.aptana.formatter.AbstractScriptFormatter;
import com.aptana.formatter.FormatterDocument;
import com.aptana.formatter.FormatterIndentDetector;
import com.aptana.formatter.FormatterUtils;
import com.aptana.formatter.FormatterWriter;
import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.IFormatterWriter;
import com.aptana.formatter.IScriptFormatter;
import com.aptana.formatter.nodes.IFormatterContainerNode;
import com.aptana.formatter.ui.FormatterException;
import com.aptana.formatter.ui.FormatterMessages;
import com.aptana.formatter.ui.ScriptFormattingContextProperties;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.ui.util.StatusLineMessageTimerManager;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class JSONFormatter
extends AbstractScriptFormatter
implements IScriptFormatter {
    protected JSONFormatter(String lineSeparator, Map<String, String> preferences, String mainContentType) {
        super(preferences, mainContentType, lineSeparator);
    }

    private FormatterDocument createFormatterDocument(String input, int offset) {
        FormatterDocument document = new FormatterDocument(input);
        document.setInt("json.formatter.formatter.tabulation.size", this.getInt("json.formatter.formatter.tabulation.size"));
        document.setInt(ScriptFormattingContextProperties.CONTEXT_ORIGINAL_OFFSET, offset);
        return document;
    }

    public int detectIndentationLevel(IDocument document, int offset, boolean isSelection, IFormattingContext formattingContext) {
        int indent = 0;
        try {
            ITypedRegion partition = document.getPartition(offset);
            if (partition != null && partition.getOffset() == offset) {
                return super.detectIndentationLevel(document, offset);
            }
            String source = document.get();
            IParseRootNode parseResult = ParserPoolFactory.parse((String)this.getMainContentType(), (String)source).getRootNode();
            if (parseResult != null) {
                JSONFormatterNodeBuilder builder = new JSONFormatterNodeBuilder();
                FormatterDocument formatterDocument = this.createFormatterDocument(source, offset);
                IFormatterContainerNode root = builder.build((IParseNode)parseResult, formatterDocument);
                new JSONFormatterNodeRewriter().rewrite(root);
                JSONFormatterContext context = new JSONFormatterContext(0);
                FormatterIndentDetector detector = new FormatterIndentDetector(offset);
                try {
                    root.accept((IFormatterContext)context, (IFormatterWriter)detector);
                    return detector.getLevel();
                }
                catch (Exception exception) {}
            }
        }
        catch (Throwable throwable) {
            return super.detectIndentationLevel(document, offset);
        }
        return indent;
    }

    public TextEdit format(String source, int offset, int length, int indentationLevel, boolean isSelection, IFormattingContext context, String indentSufix) throws FormatterException {
        String input = new String(source.substring(offset, offset + length));
        try {
            String output;
            IParseRootNode parseResult = ParserPoolFactory.parse((String)this.getMainContentType(), (String)input).getRootNode();
            if (parseResult != null && (output = this.format(input, parseResult, indentationLevel, offset, isSelection)) != null) {
                if (!input.equals(output)) {
                    return new ReplaceEdit(offset, length, output);
                }
                return new MultiTextEdit();
            }
        }
        catch (Exception e) {
            StatusLineMessageTimerManager.setErrorMessage((String)FormatterMessages.Formatter_formatterErrorStatus, (long)3000L, (boolean)true);
            IdeLog.logError((Plugin)JSONPlugin.getDefault(), (Throwable)e);
        }
        return null;
    }

    private String format(String input, IParseRootNode parseResult, int indentationLevel, int offset, boolean isSelection) throws Exception {
        int spacesCount = -1;
        if (isSelection) {
            spacesCount = JSONFormatter.countLeftWhitespaceChars((String)input);
        }
        FormatterDocument document = this.createFormatterDocument(input, offset);
        JSONFormatterNodeBuilder builder = new JSONFormatterNodeBuilder();
        IFormatterContainerNode root = builder.build((IParseNode)parseResult, document);
        JSONFormatterNodeRewriter rewriter = new JSONFormatterNodeRewriter();
        rewriter.rewrite(root);
        JSONFormatterContext context = new JSONFormatterContext(indentationLevel);
        FormatterWriter writer = new FormatterWriter((IFormatterDocument)document, this.lineSeparator, this.createIndentGenerator());
        root.accept((IFormatterContext)context, (IFormatterWriter)writer);
        writer.flush((IFormatterContext)context);
        String output = writer.getOutput();
        if (isSelection) {
            output = JSONFormatter.leftTrim((String)output, (int)spacesCount);
        }
        return output;
    }

    public int getIndentSize() {
        return this.getInt("json.formatter.formatter.indentation.size", 1);
    }

    public String getIndentType() {
        return this.getString("json.formatter.formatter.tabulation.char");
    }

    public int getTabSize() {
        return this.getInt("json.formatter.formatter.tabulation.size", this.getEditorSpecificTabWidth());
    }

    public int getEditorSpecificTabWidth() {
        return EditorUtil.getSpaceIndentSize((String)JSONPlugin.getDefault().getBundle().getSymbolicName());
    }

    public boolean isEditorInsertSpacesForTabs() {
        return FormatterUtils.isInsertSpacesForTabs((IPreferenceStore)JSONPlugin.getDefault().getPreferenceStore());
    }
}

