/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.swt;

import com.jogamp.nativewindow.swt.SWTAccessor;
import com.jogamp.newt.Display;
import com.jogamp.newt.Window;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.SurfaceUpdatedListener;
import javax.media.nativewindow.WindowClosingProtocol;
import javax.media.nativewindow.util.Insets;
import javax.media.nativewindow.util.InsetsImmutable;
import javax.media.nativewindow.util.Point;
import jogamp.nativewindow.macosx.OSXUtil;
import jogamp.nativewindow.windows.GDIUtil;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.newt.Debug;
import jogamp.newt.swt.SWTEDTUtil;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class NewtCanvasSWT
extends Canvas
implements WindowClosingProtocol {
    private static final boolean DEBUG = Debug.debug("Window");
    private final AbstractGraphicsScreen screen;
    private WindowClosingProtocol.WindowClosingMode newtChildCloseOp = WindowClosingProtocol.WindowClosingMode.DISPOSE_ON_CLOSE;
    private volatile Rectangle clientArea;
    private volatile SWTNativeWindow nativeWindow;
    private volatile Window newtChild = null;
    private volatile boolean newtChildReady = false;
    private volatile boolean postSetSize = false;

    public static NewtCanvasSWT create(final Composite composite, final int n, final Window window) {
        final NewtCanvasSWT[] newtCanvasSWTArray = new NewtCanvasSWT[]{null};
        composite.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                newtCanvasSWTArray[0] = new NewtCanvasSWT(composite, n, window);
            }
        });
        return newtCanvasSWTArray[0];
    }

    public NewtCanvasSWT(final Composite composite, int n, Window window) {
        super(composite, n | 0x40000);
        SWTAccessor.setRealized((Control)this, true);
        this.clientArea = this.getClientArea();
        AbstractGraphicsDevice abstractGraphicsDevice = SWTAccessor.getDevice((Control)this);
        this.screen = SWTAccessor.getScreen(abstractGraphicsDevice, -1);
        this.nativeWindow = null;
        if (null != window) {
            this.setNEWTChild(window);
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 9: {
                        if (null == NewtCanvasSWT.this.nativeWindow && !NewtCanvasSWT.this.validateNative() || !NewtCanvasSWT.this.newtChildReady) break;
                        if (NewtCanvasSWT.this.postSetSize) {
                            NewtCanvasSWT.this.newtChild.setSize(((NewtCanvasSWT)NewtCanvasSWT.this).clientArea.width, ((NewtCanvasSWT)NewtCanvasSWT.this).clientArea.height);
                            NewtCanvasSWT.this.postSetSize = false;
                        }
                        if (SWTAccessor.isOSX) {
                            NewtCanvasSWT.this.newtChild.setPosition(composite.getLocation().x, composite.getLocation().y);
                        }
                        NewtCanvasSWT.this.newtChild.windowRepaint(0, 0, ((NewtCanvasSWT)NewtCanvasSWT.this).clientArea.width, ((NewtCanvasSWT)NewtCanvasSWT.this).clientArea.height);
                        break;
                    }
                    case 11: {
                        NewtCanvasSWT.this.updateSizeCheck();
                        break;
                    }
                    case 12: {
                        NewtCanvasSWT.this.dispose();
                    }
                }
            }
        };
        this.addListener(11, listener);
        this.addListener(9, listener);
        this.addListener(12, listener);
    }

    protected final boolean validateNative() {
        this.updateSizeCheck();
        Rectangle rectangle = this.clientArea;
        if (0 >= rectangle.width || 0 >= rectangle.height) {
            return false;
        }
        this.screen.getDevice().open();
        long l = SWTAccessor.getWindowHandle((Control)this);
        int n = SWTAccessor.getNativeVisualID(this.screen.getDevice(), l);
        boolean bl = NativeWindowFactory.isNativeVisualIDValidForProcessing(n);
        if (DEBUG) {
            System.err.println("NewtCanvasSWT.validateNative() windowHandle 0x" + Long.toHexString(l) + ", visualID 0x" + Integer.toHexString(n) + ", valid " + bl);
        }
        if (bl) {
            Capabilities capabilities = new Capabilities();
            GraphicsConfigurationFactory graphicsConfigurationFactory = GraphicsConfigurationFactory.getFactory(this.screen.getDevice(), capabilities);
            AbstractGraphicsConfiguration abstractGraphicsConfiguration = graphicsConfigurationFactory.chooseGraphicsConfiguration(capabilities, capabilities, null, this.screen, n);
            if (DEBUG) {
                System.err.println("NewtCanvasSWT.validateNative() factory: " + graphicsConfigurationFactory + ", windowHandle 0x" + Long.toHexString(l) + ", visualID 0x" + Integer.toHexString(n) + ", chosen config: " + abstractGraphicsConfiguration);
            }
            if (null == abstractGraphicsConfiguration) {
                throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
            }
            this.nativeWindow = new SWTNativeWindow(abstractGraphicsConfiguration, l);
            this.reparentWindow(true);
        }
        return null != this.nativeWindow;
    }

    protected final void updateSizeCheck() {
        Rectangle rectangle = this.clientArea;
        Rectangle rectangle2 = this.getClientArea();
        if (rectangle2 != null && (rectangle2.width != rectangle.width || rectangle2.height != rectangle.height)) {
            this.clientArea = rectangle2;
            if (DEBUG) {
                long l = this.newtChildReady ? this.newtChild.getSurfaceHandle() : 0L;
                System.err.println("NewtCanvasSWT.sizeChanged: (" + Thread.currentThread().getName() + "): newtChildReady " + this.newtChildReady + ", " + rectangle2.x + "/" + rectangle2.y + " " + rectangle2.width + "x" + rectangle2.height + " - surfaceHandle 0x" + Long.toHexString(l));
            }
            if (this.newtChildReady) {
                this.newtChild.setSize(this.clientArea.width, this.clientArea.height);
            } else {
                this.postSetSize = true;
            }
        }
    }

    public void update() {
    }

    public void dispose() {
        if (null != this.newtChild) {
            if (DEBUG) {
                System.err.println("NewtCanvasSWT.dispose.0: EDTUtil cur " + this.newtChild.getScreen().getDisplay().getEDTUtil() + ",\n\t" + this.newtChild);
            }
            this.configureNewtChild(false);
            this.newtChild.setVisible(false);
            this.newtChild.reparentWindow(null, -1, -1, 0);
            this.newtChild.destroy();
            this.newtChild = null;
        }
        this.screen.getDevice().close();
        this.nativeWindow = null;
        super.dispose();
    }

    private Rectangle getSWTCanvasPosition() {
        return super.getBounds();
    }

    public NativeWindow getNativeWindow() {
        return this.nativeWindow;
    }

    @Override
    public WindowClosingProtocol.WindowClosingMode getDefaultCloseOperation() {
        return this.newtChildCloseOp;
    }

    @Override
    public WindowClosingProtocol.WindowClosingMode setDefaultCloseOperation(WindowClosingProtocol.WindowClosingMode windowClosingMode) {
        this.newtChildCloseOp = windowClosingMode;
        return this.newtChildCloseOp;
    }

    boolean isParent() {
        return null != this.newtChild;
    }

    boolean isFullscreen() {
        return null != this.newtChild && this.newtChild.isFullscreen();
    }

    public Window setNEWTChild(Window window) {
        Window window2 = this.newtChild;
        if (DEBUG) {
            System.err.println("NewtCanvasSWT.setNEWTChild.0: win " + NewtCanvasSWT.newtWinHandleToHexString(window2) + " -> " + NewtCanvasSWT.newtWinHandleToHexString(window));
        }
        if (null != this.newtChild) {
            this.reparentWindow(false);
            this.newtChild = null;
        }
        this.newtChild = window;
        if (null != this.nativeWindow && null != window) {
            this.reparentWindow(true);
        }
        return window2;
    }

    public Window getNEWTChild() {
        return this.newtChild;
    }

    public boolean setParent(Composite composite) {
        return super.setParent(composite);
    }

    void configureNewtChild(boolean bl) {
        this.newtChildReady = bl;
        if (null != this.newtChild) {
            this.newtChild.setKeyboardFocusHandler(null);
            if (bl) {
                this.newtChildCloseOp = this.newtChild.setDefaultCloseOperation(WindowClosingProtocol.WindowClosingMode.DO_NOTHING_ON_CLOSE);
            } else {
                this.newtChild.setFocusAction(null);
                this.newtChild.setDefaultCloseOperation(this.newtChildCloseOp);
            }
        }
    }

    void reparentWindow(boolean bl) {
        if (null == this.newtChild) {
            return;
        }
        if (DEBUG) {
            System.err.println("NewtCanvasSWT.reparentWindow.0: add=" + bl + ", win " + NewtCanvasSWT.newtWinHandleToHexString(this.newtChild) + ", EDTUtil: cur " + this.newtChild.getScreen().getDisplay().getEDTUtil());
        }
        this.newtChild.setFocusAction(null);
        if (bl) {
            this.updateSizeCheck();
            int n = this.clientArea.width;
            int n2 = this.clientArea.height;
            Display display = this.newtChild.getScreen().getDisplay();
            SWTEDTUtil sWTEDTUtil = new SWTEDTUtil(display, this.getDisplay());
            sWTEDTUtil.start();
            display.setEDTUtil(sWTEDTUtil);
            this.newtChild.setSize(n, n2);
            this.newtChild.reparentWindow((NativeWindow)this.nativeWindow, -1, -1, 2);
            this.newtChild.setVisible(true);
            this.configureNewtChild(true);
            this.newtChild.sendWindowEvent(100);
            this.setEnabled(true);
        } else {
            this.configureNewtChild(false);
            this.newtChild.setVisible(false);
            this.newtChild.reparentWindow(null, -1, -1, 0);
        }
        if (DEBUG) {
            System.err.println("NewtCanvasSWT.reparentWindow.X: add=" + bl + ", win " + NewtCanvasSWT.newtWinHandleToHexString(this.newtChild) + ", EDTUtil: cur " + this.newtChild.getScreen().getDisplay().getEDTUtil());
        }
    }

    private final void requestFocusNEWTChild() {
        if (this.newtChildReady) {
            this.newtChild.setFocusAction(null);
            this.newtChild.requestFocus();
        }
    }

    public boolean forceFocus() {
        boolean bl = NewtCanvasSWT.super.forceFocus();
        this.requestFocusNEWTChild();
        return bl;
    }

    static String newtWinHandleToHexString(Window window) {
        return null != window ? NewtCanvasSWT.toHexString(window.getWindowHandle()) : "nil";
    }

    static String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }

    private class SWTNativeWindow
    implements NativeWindow {
        private final AbstractGraphicsConfiguration config;
        private final long nativeWindowHandle;
        private final InsetsImmutable insets;

        public SWTNativeWindow(AbstractGraphicsConfiguration abstractGraphicsConfiguration, long l) {
            this.config = abstractGraphicsConfiguration;
            this.nativeWindowHandle = l;
            this.insets = SWTAccessor.isOSX ? OSXUtil.GetInsets(l) : new Insets(0, 0, 0, 0);
        }

        @Override
        public int lockSurface() throws NativeWindowException, RuntimeException {
            return 3;
        }

        @Override
        public void unlockSurface() {
        }

        @Override
        public boolean isSurfaceLockedByOtherThread() {
            return false;
        }

        @Override
        public Thread getSurfaceLockOwner() {
            return null;
        }

        @Override
        public boolean surfaceSwap() {
            return false;
        }

        @Override
        public void addSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        }

        @Override
        public void addSurfaceUpdatedListener(int n, SurfaceUpdatedListener surfaceUpdatedListener) throws IndexOutOfBoundsException {
        }

        @Override
        public void removeSurfaceUpdatedListener(SurfaceUpdatedListener surfaceUpdatedListener) {
        }

        @Override
        public long getSurfaceHandle() {
            return 0L;
        }

        @Override
        public int getWidth() {
            return ((NewtCanvasSWT)NewtCanvasSWT.this).clientArea.width;
        }

        @Override
        public int getHeight() {
            return ((NewtCanvasSWT)NewtCanvasSWT.this).clientArea.height;
        }

        @Override
        public AbstractGraphicsConfiguration getGraphicsConfiguration() {
            return this.config;
        }

        @Override
        public long getDisplayHandle() {
            return this.config.getScreen().getDevice().getHandle();
        }

        @Override
        public int getScreenIndex() {
            return this.config.getScreen().getIndex();
        }

        @Override
        public void surfaceUpdated(Object object, NativeSurface nativeSurface, long l) {
        }

        @Override
        public void destroy() {
        }

        @Override
        public NativeWindow getParent() {
            return null;
        }

        @Override
        public long getWindowHandle() {
            return this.nativeWindowHandle;
        }

        @Override
        public InsetsImmutable getInsets() {
            return this.insets;
        }

        @Override
        public int getX() {
            return 0;
        }

        @Override
        public int getY() {
            return 0;
        }

        @Override
        public Point getLocationOnScreen(Point point) {
            Point point2;
            if (SWTAccessor.isOSX) {
                point2 = OSXUtil.GetLocationOnScreen(this.nativeWindowHandle, false, 0, 0);
                Rectangle rectangle = NewtCanvasSWT.this.getSWTCanvasPosition();
                point2.translate(rectangle.x + this.insets.getLeftWidth(), rectangle.y + this.insets.getTopHeight());
            } else if (SWTAccessor.isX11) {
                AbstractGraphicsScreen abstractGraphicsScreen = this.config.getScreen();
                point2 = X11Lib.GetRelativeLocation(abstractGraphicsScreen.getDevice().getHandle(), abstractGraphicsScreen.getIndex(), this.nativeWindowHandle, 0L, 0, 0);
            } else {
                point2 = SWTAccessor.isWindows ? GDIUtil.GetRelativeLocation(this.nativeWindowHandle, 0L, 0, 0) : new Point(0, 0);
            }
            if (null != point) {
                return point.translate(point2);
            }
            return point2;
        }

        @Override
        public boolean hasFocus() {
            return NewtCanvasSWT.this.isFocusControl();
        }
    }
}

