/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.views;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.html.contentassist.model.BaseElement;
import com.aptana.editor.html.contentassist.model.CSSReferencesGroup;
import com.aptana.editor.html.contentassist.model.HTMLElement;
import com.aptana.editor.html.contentassist.model.JSReferencesGroup;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class HTMLIndexViewContentProvider
implements ITreeContentProvider {
    private static final Object[] NO_ELEMENTS = new Object[0];

    public void dispose() {
    }

    public Object[] getChildren(Object parentElement) {
        List<Object> result = Collections.emptyList();
        if (parentElement instanceof HTMLElement) {
            HTMLElement root = (HTMLElement)parentElement;
            result = CollectionsUtil.newList((Object[])new BaseElement[]{new CSSReferencesGroup(root.getIndex()), new JSReferencesGroup(root.getIndex())});
        } else if (parentElement instanceof CSSReferencesGroup) {
            result = ((CSSReferencesGroup)parentElement).getReferences();
        } else if (parentElement instanceof JSReferencesGroup) {
            result = ((JSReferencesGroup)parentElement).getReferences();
        }
        return result.toArray(new Object[result.size()]);
    }

    public Object[] getElements(Object inputElement) {
        Object[] result;
        if (inputElement instanceof IProject) {
            IProject project = (IProject)inputElement;
            Index index = this.getIndexManager().getIndex(project.getLocationURI());
            result = new Object[]{new HTMLElement(index)};
        } else {
            result = NO_ELEMENTS;
        }
        return result;
    }

    protected IndexManager getIndexManager() {
        return IndexPlugin.getDefault().getIndexManager();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

