/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.validator;

import com.aptana.build.ui.preferences.IBuildParticipantPreferenceCompositeFactory;
import com.aptana.core.build.IBuildParticipantWorkingCopy;
import com.aptana.core.build.IProblem;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.html.validator.HTMLTidyValidator;
import com.aptana.ui.preferences.ScrolledPageContent;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class HTMLTidyValidatorPreferenceCompositeFactory
implements IBuildParticipantPreferenceCompositeFactory {
    private IBuildParticipantWorkingCopy participant;

    public Composite createPreferenceComposite(Composite parent, IBuildParticipantWorkingCopy participant) {
        this.participant = participant;
        Composite mainComp = new Composite(parent, 0);
        mainComp.setFont(parent.getFont());
        mainComp.setLayout((Layout)new FillLayout());
        ScrolledPageContent pageContent = new ScrolledPageContent(mainComp);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite composite = pageContent.getBody();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        EnumMap<HTMLTidyValidator.ProblemCategory, List> map = new EnumMap<HTMLTidyValidator.ProblemCategory, List>(HTMLTidyValidator.ProblemCategory.class);
        HTMLTidyValidator.ProblemType[] problemTypeArray = HTMLTidyValidator.ProblemType.values();
        int n = problemTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            List types;
            HTMLTidyValidator.ProblemType type = problemTypeArray[n2];
            if (map.containsKey((Object)type.category())) {
                types = (List)map.get((Object)type.category());
                types.add(type);
            } else {
                types = CollectionsUtil.newList((Object[])new HTMLTidyValidator.ProblemType[]{type});
            }
            map.put(type.category(), types);
            ++n2;
        }
        for (Map.Entry entry : map.entrySet()) {
            ExpandableComposite excomposite = new ExpandableComposite(composite, 0, 18);
            excomposite.setText(entry.getKey().label());
            excomposite.setExpanded(false);
            excomposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
            excomposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            excomposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    HTMLTidyValidatorPreferenceCompositeFactory.this.expandedStateChanged((ExpandableComposite)e.getSource());
                }
            });
            this.makeScrollableCompositeAware((Control)excomposite);
            Composite othersComposite = new Composite((Composite)excomposite, 0);
            excomposite.setClient((Control)othersComposite);
            othersComposite.setLayout((Layout)new GridLayout(2, false));
            for (HTMLTidyValidator.ProblemType type : (List)entry.getValue()) {
                this.createEntry(type, othersComposite);
            }
        }
        return mainComp;
    }

    protected void createEntry(HTMLTidyValidator.ProblemType type, Composite group) {
        Label label1 = new Label(group, 64);
        label1.setText(type.description());
        label1.setLayoutData((Object)new GridData(1, 2, true, false));
        final Combo combo = new Combo(group, 12);
        combo.add(IProblem.Severity.IGNORE.label());
        combo.add(IProblem.Severity.INFO.label());
        combo.add(IProblem.Severity.WARNING.label());
        combo.add(IProblem.Severity.ERROR.label());
        final String prefKey = type.getPrefKey();
        int num = this.participant.getPreferenceInt(type.getPrefKey(), IProblem.Severity.WARNING.intValue());
        IProblem.Severity severity = IProblem.Severity.create((int)num);
        combo.setText(severity.label());
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = combo.getText();
                IProblem.Severity severity = IProblem.Severity.create((String)text);
                HTMLTidyValidatorPreferenceCompositeFactory.this.participant.setPreference(prefKey, (Object)severity.intValue());
            }
        });
        combo.setLayoutData((Object)new GridData(256));
        this.makeScrollableCompositeAware((Control)combo);
    }

    protected ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ScrolledPageContent) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledPageContent) {
            return (ScrolledPageContent)parent;
        }
        return null;
    }

    protected ExpandableComposite getParentExpandableComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ExpandableComposite) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ExpandableComposite) {
            return (ExpandableComposite)parent;
        }
        return null;
    }

    private void makeScrollableCompositeAware(Control control) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite(control);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.adaptChild(control);
        }
    }

    protected final void expandedStateChanged(ExpandableComposite expandable) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite((Control)expandable);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.reflow(true);
        }
    }
}

