/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.validator;

import com.aptana.buildpath.core.BuildPathCorePlugin;
import com.aptana.core.IFilter;
import com.aptana.core.build.AbstractRemoteBuildParticipant;
import com.aptana.core.build.IBuildParticipant;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.resolver.URIResolver;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.html.parsing.HTMLParseState;
import com.aptana.editor.html.parsing.ast.HTMLSpecialNode;
import com.aptana.editor.html.validator.HTMLScriptReferencesProblem;
import com.aptana.editor.html.validator.Messages;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.contentassist.JSIndexQueryHelper;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.editor.js.inferencing.JSScope;
import com.aptana.editor.js.parsing.ast.JSArgumentsNode;
import com.aptana.editor.js.parsing.ast.JSAssignmentNode;
import com.aptana.editor.js.parsing.ast.JSBinaryOperatorNode;
import com.aptana.editor.js.parsing.ast.JSDeclarationNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.build.BuildContext;
import com.aptana.parsing.ParseState;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseNodeAttribute;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.util.ParseUtil;
import com.pandora.core.utils.ProjectUtils;
import com.pandora.core.utils.URIUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;

public class HTMLScriptStyleValidator
extends AbstractRemoteBuildParticipant {
    public static final String ID = "com.aptana.editor.html.validator.HtmlScriptStyleValidator";
    private static final String ELEMENT_SCRIPT = "script";
    private static final String ATTRIBUTE_SRC = "src";
    private JSIndexQueryHelper jSIndexQueryHelper = new JSIndexQueryHelper();
    private BuildContext context;
    private Set<String> localJSReferences = new HashSet<String>();
    private Index index = null;
    protected String sourcePath;
    private Collection<HTMLScriptReferencesProblem> fixproblems = new ArrayList<HTMLScriptReferencesProblem>();
    private Collection<HTMLScriptReferencesProblem> problems = new ArrayList<HTMLScriptReferencesProblem>();
    private IProgressMonitor monitor;

    public void initContext(BuildContext context) {
        List problems = Collections.emptyList();
        context.putProblems("com.aptana.editor.html.js_ref_problem", problems);
        context.putProblems("com.aptana.editor.html.js_ref_error", problems);
    }

    public boolean needBuildFile(BuildContext context) {
        return this.needValidatorBuildFile(context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set<IFile> relatedFile(BuildContext context, IBuildParticipant.RelatedType type, IProgressMonitor monitor) {
        this.context = context;
        try {
            if (!"com.aptana.contenttype.js".equals(context.getContentType()) || context.isSave()) {
                return null;
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        HashSet<IFile> relatedFiles = new HashSet<IFile>();
        if (IBuildParticipant.RelatedType.DELETE == type) {
            Set<String> paths;
            Map<String, Set<String>> jSReferencesMap = new HTMLIndexQueryHelper().getJSReferences(IndexPlugin.getDefault().getIndexManager().getIndex(context.getProject().getLocationURI()));
            if (jSReferencesMap == null || (paths = jSReferencesMap.get(context.getFile().getLocationURI().toString())) == null || paths.isEmpty()) return relatedFiles;
            for (String path : paths) {
                try {
                    IFile file = context.getProject().getFile(path);
                    if (!(file instanceof IFile)) continue;
                    relatedFiles.add(file);
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
                }
            }
            return relatedFiles;
        } else {
            try {
                IProject resource = context.getProject();
                IMarker[] markers = resource.findMarkers("com.aptana.editor.html.js_ref_error", true, 2);
                if (markers == null || markers.length <= 0) return relatedFiles;
                IMarker[] iMarkerArray = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    if (marker.getResource() instanceof IFile) {
                        relatedFiles.add((IFile)marker.getResource());
                    }
                    ++n2;
                }
                return relatedFiles;
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
            }
        }
        return relatedFiles;
    }

    public void buildFile(BuildContext context, final IProgressMonitor monitor) {
        if (monitor == null || monitor.isCanceled()) {
            return;
        }
        try {
            if (context == null || !"com.aptana.contenttype.html".equals(context.getContentType())) {
                return;
            }
        }
        catch (CoreException coreException) {
            return;
        }
        if (!this.needBuildFile(context)) {
            return;
        }
        this.context = context;
        this.monitor = monitor;
        this.sourcePath = context.getURI().toString();
        IParseRootNode ast = null;
        try {
            context.setParseState((ParseState)new HTMLParseState(context.getContents()));
            ast = context.getAST();
        }
        catch (CoreException coreException) {}
        try {
            try {
                if (ast != null) {
                    final Document doc = new Document(context.getContents());
                    com.aptana.parsing.util.ParseUtil.treeApply((IParseNode)ast, (ParseUtil.IASTVisitor)new ParseUtil.IASTVisitor(){

                        public boolean exitNode(IParseNode node) {
                            return true;
                        }

                        public boolean enterNode(IParseNode node) {
                            if (monitor.isCanceled()) {
                                return true;
                            }
                            HTMLScriptStyleValidator.this.enterNode(doc, node);
                            return true;
                        }
                    });
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)MessageFormat.format("Failed to parse {0} for HTML Sctipy Style Validation", this.sourcePath), (Throwable)e);
                this.updateMarkers(context, monitor);
                this.problems.clear();
                this.fixproblems.clear();
            }
        }
        finally {
            this.updateMarkers(context, monitor);
            this.problems.clear();
            this.fixproblems.clear();
        }
    }

    private void updateMarkers(BuildContext context, IProgressMonitor monitor) {
        final IFile file = context.getFile();
        final List filters = this.getFilters();
        IFilter<HTMLScriptReferencesProblem> filter = new IFilter<HTMLScriptReferencesProblem>(){

            public boolean include(HTMLScriptReferencesProblem item) {
                return !HTMLScriptStyleValidator.this.isIgnored(item.getMessage(), filters);
            }
        };
        this.problems = CollectionsUtil.filter(this.problems, (IFilter)filter);
        this.fixproblems = CollectionsUtil.filter(this.fixproblems, (IFilter)filter);
        final ConcurrentHashMap<String, Collection<HTMLScriptReferencesProblem>> itemsByType = new ConcurrentHashMap<String, Collection<HTMLScriptReferencesProblem>>();
        itemsByType.put("com.aptana.editor.html.js_ref_problem", this.fixproblems);
        itemsByType.put("com.aptana.editor.html.js_ref_error", this.problems);
        if (CollectionsUtil.isEmpty(itemsByType)) {
            return;
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) {
                HTMLScriptStyleValidator.this.updateMarkers(file, itemsByType, monitor);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, this.getMarkerRule(file), 1, monitor);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (String)"Error updating markers", (Throwable)e);
        }
    }

    private ISchedulingRule getMarkerRule(Object resource) {
        if (resource instanceof IResource) {
            return ResourcesPlugin.getWorkspace().getRuleFactory().markerRule((IResource)resource);
        }
        return null;
    }

    private synchronized void updateMarkers(IFile file, Map<String, Collection<HTMLScriptReferencesProblem>> itemsByType, IProgressMonitor monitor) {
        if (!file.exists()) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(itemsByType.size() * 10));
        for (String markerType : itemsByType.keySet()) {
            try {
                Collection<HTMLScriptReferencesProblem> newItems = itemsByType.get(markerType);
                file.deleteMarkers(markerType, false, 2);
                sub.worked(1);
                this.addMarkers(newItems, markerType, file, (IProgressMonitor)sub.newChild(9));
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
            }
        }
        sub.done();
    }

    private void addMarkers(Collection<HTMLScriptReferencesProblem> items, String markerType, IFile file, IProgressMonitor monitor) throws CoreException {
        if (CollectionsUtil.isEmpty(items)) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(items.size() * 2));
        for (HTMLScriptReferencesProblem item : items) {
            IMarker marker = file.createMarker(markerType);
            sub.worked(1);
            marker.setAttributes(item.createMarkerAttributes());
            sub.worked(1);
        }
        sub.done();
    }

    protected boolean checkJsReferences(Document doc, JSIdentifierNode node) {
        List<String> srcJs = this.getNoReferenceJs(node);
        if (!CollectionsUtil.isEmpty(srcJs)) {
            this.fixproblems.add(this.createQuickFixWarning(doc, MessageFormat.format(Messages.HTMLScriptStyleValidator_Not_References_Js, node.getNameNode().getName()), (IParseNode)node, new HashSet<String>(srcJs)));
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<String> getNoReferenceJs(JSIdentifierNode node) {
        this.monitor.subTask(node.getText());
        Collection<Object> pes = new ArrayList<PropertyElement>();
        IProject project = this.context.getProject();
        IFile file = this.context.getFile();
        if (project == null || file == null) {
            return null;
        }
        if (this.isInCurrentPage(node)) {
            return null;
        }
        if (node.getParent() instanceof JSGetPropertyNode) {
            if (node.equals((Object)node.getParent().getFirstChild())) {
                pes = this.jSIndexQueryHelper.getGlobals(this.getIndex(), project, file.getName(), node.getNameNode().getName(), true);
            } else {
                IParseNode previousNode = ((JSGetPropertyNode)node.getParent()).getPreviousNode();
                if (previousNode instanceof JSAssignmentNode || previousNode instanceof JSBinaryOperatorNode) {
                    return null;
                }
                List typeList = ParseUtil.getParentObjectTypes((Index)this.getIndex(), (URI)file.getLocationURI(), (IParseNode)node, (JSGetPropertyNode)((JSGetPropertyNode)node.getParent()), (int)node.getStartingOffset());
                for (String typeName : typeList) {
                    if (this.monitor.isCanceled()) {
                        return null;
                    }
                    List allTypes = this.jSIndexQueryHelper.getTypeAncestorNames(this.getIndex(), typeName);
                    allTypes.add(0, typeName);
                    for (String type : allTypes) {
                        if (this.monitor.isCanceled()) {
                            return null;
                        }
                        pes.addAll(this.jSIndexQueryHelper.getTypeMembers(this.getIndex(), type, node.getNameNode().getName(), true));
                    }
                }
            }
        } else if (node.getParent() instanceof JSInvokeNode) {
            if (node.equals((Object)node.getParent().getFirstChild())) {
                pes = this.jSIndexQueryHelper.getGlobals(this.getIndex(), project, file.getName(), node.getNameNode().getName(), true);
            }
        } else if (node.getParent() instanceof JSArgumentsNode || node.getParent() instanceof JSBinaryOperatorNode || node.getParent() instanceof JSAssignmentNode || node.getParent() instanceof JSDeclarationNode) {
            pes = this.jSIndexQueryHelper.getGlobals(this.getIndex(), project, file.getName(), node.getNameNode().getName(), true);
        }
        if (pes != null && !pes.isEmpty() && !this.isJsImport(pes)) {
            try {
                URI projectUri = project.getLocationURI();
                String htmlpath = projectUri.relativize(file.getLocationURI()).toString();
                Iterator<Object> itpes = pes.iterator();
                ArrayList<String> jspaths = new ArrayList<String>();
                while (itpes.hasNext()) {
                    String jsPath = ((PropertyElement)itpes.next()).getDefineJS();
                    if (jsPath.endsWith(".js")) {
                        jsPath = projectUri.relativize(new URI(jsPath)).toString();
                        jspaths.add(URIUtils.relativeURI((String)htmlpath, (String)jsPath));
                        continue;
                    }
                    if (!file.getLocationURI().equals(new URI(jsPath))) continue;
                    return null;
                }
                return jspaths;
            }
            catch (URISyntaxException e) {
                IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
            }
        }
        return null;
    }

    protected boolean isInCurrentPage(JSIdentifierNode targetNode) {
        JSScope globalScope;
        if (targetNode != null && (globalScope = ParseUtil.getGlobalScope((IParseNode)targetNode)) != null) {
            JSScope localScope = globalScope.getScopeAtOffset(targetNode.getStartingOffset());
            while (localScope != null && localScope != globalScope) {
                if (this.monitor.isCanceled()) {
                    return true;
                }
                List symbols = localScope.getLocalSymbolNames();
                for (String symbol : symbols) {
                    if (!symbol.equals(targetNode.getText())) continue;
                    return true;
                }
                localScope = localScope.getParentScope();
            }
        }
        return false;
    }

    private boolean isJsImport(Collection<PropertyElement> pes) {
        for (PropertyElement pe : pes) {
            if (this.monitor.isCanceled()) {
                return true;
            }
            if (StringUtil.isBlank((String)pe.getDefineJS()) || !pe.getDefineJS().endsWith(".js")) {
                return true;
            }
            if (!this.checkURI(pe.getDefineJS()) && !this.checkURI(HTMLScriptStyleValidator.transformScriptURI(pe.getDefineJS()).toString())) continue;
            return true;
        }
        return false;
    }

    private boolean checkURI(String defineJS) {
        return this.localJSReferences.contains(defineJS);
    }

    protected void enterNode(Document doc, IParseNode node) {
        if (this.monitor.isCanceled()) {
            return;
        }
        if (node instanceof HTMLSpecialNode) {
            HTMLSpecialNode htmlSpecialNode = (HTMLSpecialNode)node;
            if (htmlSpecialNode.getName().equalsIgnoreCase(ELEMENT_SCRIPT)) {
                String jsSource = htmlSpecialNode.getAttributeValue(ATTRIBUTE_SRC);
                if (StringUtil.isBlank((String)jsSource) || jsSource.trim().startsWith("<") || jsSource.trim().startsWith("{")) {
                    return;
                }
                if (jsSource.startsWith("//")) {
                    jsSource = "http:" + jsSource;
                }
                if (jsSource.contains("?")) {
                    jsSource = jsSource.substring(0, jsSource.indexOf("?"));
                }
                IParseNodeAttribute attribute = htmlSpecialNode.getAttribute(ATTRIBUTE_SRC);
                IRange range = attribute.getValueRange();
                URI uri = null;
                try {
                    uri = new URI(jsSource);
                }
                catch (URISyntaxException uRISyntaxException) {
                    this.problems.add(this.createError(doc, "\u5f15\u7528\u7684\u6587\u4ef6\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u6587\u4ef6\u8def\u5f84\u683c\u5f0f\u662f\u5426\u6b63\u786e", range.getStartingOffset(), range.getLength()));
                    return;
                }
                if (StringUtil.isNotBlank((String)uri.getScheme()) && !uri.getScheme().toLowerCase().equals("file")) {
                    uri = HTMLScriptStyleValidator.transformScriptURI(uri.getPath());
                    this.localJSReferences.add(uri.toString());
                    return;
                }
                if (jsSource != null) {
                    URIResolver resolver = null;
                    if (jsSource.startsWith("/")) {
                        try {
                            IPath sourceRoot = ProjectUtils.getSourceRoot((IProject)this.context.getProject());
                            if (sourceRoot != null) {
                                uri = sourceRoot.toFile().toURI();
                                resolver = new URIResolver(uri);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        jsSource = jsSource.substring(1, jsSource.length());
                    } else {
                        uri = this.context.getURI();
                        resolver = new URIResolver(uri);
                    }
                    URI resolved = resolver.resolveURI(jsSource);
                    if (resolved == null) {
                        this.problems.add(this.createError(doc, "\u5f15\u7528\u7684\u6587\u4ef6\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u6587\u4ef6\u8def\u5f84\u662f\u5426\u6b63\u786e", range.getStartingOffset(), range.getLength()));
                    } else {
                        this.localJSReferences.add(resolved.toString());
                    }
                }
            }
        } else if (node instanceof JSIdentifierNode) {
            this.checkJsReferences(doc, (JSIdentifierNode)node);
        }
    }

    private Index getIndex() {
        if (this.index == null && this.context != null && this.context.getProject() != null) {
            this.index = IndexPlugin.getDefault().getIndexManager().getIndex(this.context.getProject().getLocationURI());
        }
        return this.index;
    }

    protected HTMLScriptReferencesProblem createQuickFixWarning(Document doc, String msg, IParseNode node, Set<String> missingScripts) {
        return this.createQuickFixWarning(doc, msg, node.getStartingOffset(), node.getLength(), missingScripts);
    }

    protected HTMLScriptReferencesProblem createQuickFixWarning(Document doc, String msg, int start, int length, Set<String> missingScripts) {
        int line = -1;
        try {
            line = doc.getLineOfOffset(start) + 1;
        }
        catch (BadLocationException badLocationException) {}
        return this.createQuickFixWarning(msg, line, start, length, this.sourcePath, missingScripts);
    }

    protected HTMLScriptReferencesProblem createQuickFixWarning(String message, int lineNumber, int offset, int length, String sourcePath, Set<String> missingScripts) {
        HTMLScriptReferencesProblem quickfix = new HTMLScriptReferencesProblem(1, message, offset, length, lineNumber, sourcePath);
        quickfix.setQuickFixable(true);
        quickfix.setMissingScripts(missingScripts);
        return quickfix;
    }

    protected HTMLScriptReferencesProblem createError(Document doc, String msg, int start, int length) {
        int line = -1;
        try {
            line = doc.getLineOfOffset(start) + 1;
        }
        catch (BadLocationException badLocationException) {}
        HTMLScriptReferencesProblem quickfix = new HTMLScriptReferencesProblem(2, msg, start, length, line, this.sourcePath);
        quickfix.setQuickFixable(false);
        return quickfix;
    }

    public static URI transformScriptURI(String scriptUrl) {
        if (scriptUrl != null) {
            int index = (scriptUrl = scriptUrl.replace("min.", "").replace(".min.", ".").replaceAll("[.|-]\\d+", "")).lastIndexOf("/");
            if (index >= 0) {
                scriptUrl = scriptUrl.substring(index);
            }
            try {
                return new URI("http", "localhost", scriptUrl, null);
            }
            catch (URISyntaxException e) {
                IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
            }
        }
        return null;
    }

    public void deleteFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        context.removeProblems("com.aptana.editor.html.js_ref_problem");
        context.removeProblems("com.aptana.editor.html.js_ref_error");
    }
}

