/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.validator;

import com.aptana.core.build.AbstractRemoteBuildParticipant;
import com.aptana.core.build.IProblem;
import com.aptana.core.build.Problem;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.html.parsing.HTMLParseState;
import com.aptana.index.core.build.BuildContext;
import com.aptana.parsing.ParseState;
import com.aptana.parsing.ast.IParseError;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;

public class HTMLParserValidator
extends AbstractRemoteBuildParticipant {
    public static final String ID = "com.aptana.editor.html.validator.HTMLParseErrorValidator";

    public void initContext(BuildContext context) {
        List problems = Collections.emptyList();
        context.putProblems("com.aptana.editor.html.problem", problems);
    }

    public boolean needBuildFile(BuildContext context) {
        return this.needValidatorBuildFile(context);
    }

    public void buildFile(BuildContext context, IProgressMonitor monitor) {
        if (monitor.isCanceled() || !this.needBuildFile(context)) {
            return;
        }
        try {
            HTMLParseState htmlParseState = new HTMLParseState(context.getContents());
            htmlParseState.setParseNestedLanguage(false);
            context.setParseState((ParseState)htmlParseState);
            context.getAST();
        }
        catch (CoreException coreException) {}
        Map<String, List<IProblem>> problems = this.detectErrors(context);
        context.putProblems("com.aptana.editor.html.problem", (Collection)problems.get("com.aptana.contenttype.html"));
    }

    public Map<String, List<IProblem>> detectErrors(BuildContext context) {
        Collection errorList;
        HashMap<String, List<IProblem>> problems = new HashMap<String, List<IProblem>>();
        problems.put("com.aptana.contenttype.html", new ArrayList());
        String source = context.getContents();
        if (!StringUtil.isEmpty((String)source) && !CollectionsUtil.isEmpty((Collection)(errorList = context.getParseErrors()))) {
            URI path = context.getURI();
            String sourcePath = path.toString();
            Document doc = new Document(source);
            for (IParseError parseError : errorList) {
                int severity = parseError.getSeverity() == IParseError.Severity.ERROR ? 2 : 1;
                int line = -1;
                try {
                    line = doc.getLineOfOffset(parseError.getOffset()) + 1;
                }
                catch (BadLocationException badLocationException) {}
                String language = parseError.getLangauge();
                List langProblems = (List)problems.get(language);
                if (langProblems == null) continue;
                langProblems.add(new Problem(severity, parseError.getMessage(), parseError.getOffset(), parseError.getLength(), line, sourcePath));
                problems.put(language, langProblems);
            }
        }
        return problems;
    }

    public void deleteFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        context.removeProblems("com.aptana.editor.html.problem");
        context.removeProblems("com.aptana.editor.js.problem");
        context.removeProblems("com.aptana.editor.css.problem");
    }

    public boolean isEnabled() {
        return true;
    }
}

