/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.validator;

import com.aptana.core.IFilter;
import com.aptana.core.build.IProblem;
import com.aptana.core.build.Problem;
import com.aptana.core.logging.IdeLog;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.parsing.HTMLParseState;
import com.aptana.editor.html.parsing.HTMLParser;
import com.aptana.editor.html.parsing.ast.HTMLSpecialNode;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.validator.MozillaJsValidator;
import com.aptana.index.core.build.BuildContext;
import com.aptana.parsing.ParseState;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.util.ParseUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;

public class HTMLMozillaJsValidator
extends MozillaJsValidator {
    public List<IProblem> detectErrors(BuildContext context, final IProgressMonitor monitor) {
        ArrayList<IProblem> problems = new ArrayList<IProblem>();
        String sourcePath = context.getURI().toString();
        monitor.subTask("Javascript \u6821\u9a8c: " + sourcePath);
        IParseRootNode ast = null;
        try {
            context.setParseState((ParseState)new HTMLParseState(context.getContents()));
            ast = context.getAST();
        }
        catch (CoreException coreException) {}
        try {
            if (ast != null) {
                Document doc = new Document(context.getContents());
                ParseUtil.treeApply((IParseNode)ast, (IFilter)new IFilter<IParseNode>((IDocument)doc, sourcePath, problems){
                    private final /* synthetic */ IDocument val$doc;
                    private final /* synthetic */ String val$sourcePath;
                    private final /* synthetic */ List val$problems;
                    {
                        this.val$doc = iDocument;
                        this.val$sourcePath = string;
                        this.val$problems = list;
                    }

                    public boolean include(IParseNode node) {
                        if (monitor.isCanceled()) {
                            return false;
                        }
                        try {
                            int end;
                            HTMLSpecialNode htmlSpecialNode;
                            int start;
                            String type;
                            if (node instanceof HTMLSpecialNode && "script".equalsIgnoreCase(node.getElementName()) && ((type = ((HTMLSpecialNode)node).getAttributeValue("type")) == null || HTMLParser.isJavaScript((HTMLSpecialNode)node)) && (start = (htmlSpecialNode = (HTMLSpecialNode)node).getNameNode().getNameRange().getEndingOffset() + 1) < (end = htmlSpecialNode.getEndNode().getNameRange().getStartingOffset())) {
                                List errors = HTMLMozillaJsValidator.this.parseWithMozilla(this.val$doc.get(start, end - start), this.val$sourcePath, monitor);
                                for (IProblem error : errors) {
                                    if (error instanceof Problem) {
                                        Problem problem = (Problem)error;
                                        problem.setOffset(problem.getOffset() + start);
                                        problem.setLineNumber(this.val$doc.getLineOfOffset(problem.getOffset()));
                                    }
                                    this.val$problems.add(error);
                                }
                            }
                        }
                        catch (Exception e) {
                            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
                        }
                        return true;
                    }
                }, (boolean)context.isNeedSleep());
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)MessageFormat.format("Failed to parse {0} with MozillaJs", sourcePath), (Throwable)e);
        }
        return problems;
    }

    protected String getPreferenceNode() {
        return "com.aptana.editor.js";
    }

    public boolean isEnabled() {
        return true;
    }
}

