/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.text.hyperlink;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.js.JSPlugin;
import java.io.File;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;

public class StringSearchHyperlink
implements IHyperlink {
    private IRegion hyperlinkRegion = null;
    private String hyperlinkText = null;
    private IRegion targetRegion = null;
    private URI fileUri = null;

    public StringSearchHyperlink(IRegion hyperlinkRegion, String hyperlinkText, IRegion targetRegion, URI fileUri) {
        this.hyperlinkRegion = hyperlinkRegion;
        this.hyperlinkText = hyperlinkText;
        this.targetRegion = targetRegion;
        this.fileUri = fileUri;
    }

    public IRegion getHyperlinkRegion() {
        return this.hyperlinkRegion;
    }

    public String getTypeLabel() {
        return "";
    }

    public String getHyperlinkText() {
        return this.hyperlinkText;
    }

    protected AbstractThemeableEditor getEditor() {
        IEditorPart part = null;
        if (this.fileUri != null) {
            try {
                File file = new File(this.fileUri);
                if (file.exists()) {
                    part = EditorUtil.openInEditor((File)file);
                } else {
                    IResource findMember = ResourcesPlugin.getWorkspace().getRoot().findMember(this.fileUri.toString());
                    if (findMember instanceof IFile && findMember.exists()) {
                        part = EditorUtil.openInEditor((File)new File(((IFile)findMember).getLocationURI()));
                    }
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
            }
        }
        return part instanceof AbstractThemeableEditor ? (AbstractThemeableEditor)part : null;
    }

    public void open() {
        AbstractThemeableEditor editor;
        if (this.targetRegion != null && (editor = this.getEditor()) != null) {
            editor.selectAndReveal(this.targetRegion.getOffset(), this.targetRegion.getLength());
        }
    }
}

