/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.text;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.text.RubyRegexpAutoIndentStrategy;
import com.aptana.editor.html.HTMLEditor;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.parsing.HTMLParseState;
import com.aptana.editor.xml.TagUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class HTMLAutoIndentStrategy
extends RubyRegexpAutoIndentStrategy {
    ISourceViewer sourceViewer;
    private static Map<String, String[]> matchMap = new HashMap<String, String[]>();

    public HTMLAutoIndentStrategy(String contentType, SourceViewerConfiguration configuration, ISourceViewer sourceViewer, IPreferenceStore prefStore) {
        super(contentType, configuration, sourceViewer, prefStore);
        this.sourceViewer = sourceViewer;
    }

    protected boolean autoIndent(IDocument d, DocumentCommand c) {
        ITypedRegion curLineRegion;
        block7: {
            curLineRegion = d.getPartition(c.offset);
            int previousOffset = curLineRegion.getOffset() - 1;
            if (previousOffset >= 0) break block7;
            return false;
        }
        try {
            ITypedRegion previousRegion_ = d.getPartition(curLineRegion.getOffset() - 1);
            if (previousRegion_ == null) {
                return super.autoIndent(d, c);
            }
            if (previousRegion_.getType() == "__html_tag") {
                IRegion match;
                String previouContent = d.get(previousRegion_.getOffset(), previousRegion_.getLength());
                if (StringUtil.isBlank((String)previouContent)) {
                    return super.autoIndent(d, c);
                }
                String tagName = TagUtil.getTagName((String)previouContent);
                if (StringUtil.isNotBlank((String)tagName) && HTMLParseState.isEndForbiddenOrEmptyTag(tagName) && (match = TagUtil.findMatchingTag((IDocument)d, (int)previousRegion_.getOffset(), HTMLEditor.tagPartitions)) == null) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
        }
        return super.autoIndent(d, c);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getAutoIndentAfterNewLine(IDocument d, DocumentCommand c, boolean change) {
        if (c.offset == -1 || d.getLength() == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        try {
            int nextLineNumber;
            IRegion infoParent;
            IRegion match;
            int regionEnd;
            ITypedRegion region = d.getPartition(c.offset);
            IRegion infoCurrentLine = d.getLineInformationOfOffset(c.offset);
            int infoCurrentLineEnd = infoCurrentLine.getOffset() + infoCurrentLine.getLength();
            int emptyEnd = regionEnd = region.getOffset() + region.getLength();
            if (infoCurrentLineEnd < regionEnd) {
                emptyEnd = infoCurrentLineEnd;
            }
            if (change && d.get(c.offset, emptyEnd - c.offset).trim().length() == 0) {
                d.replace(c.offset, emptyEnd - c.offset, "");
            }
            if ((match = TagUtil.findMatchingTag((IDocument)d, (int)(c.offset + c.length), HTMLEditor.tagPartitions)) != null) {
                infoParent = d.getLineInformationOfOffset(match.getOffset());
                String indent = "";
                int start = infoParent.getOffset();
                int end = this.findEndOfWhiteSpace(d, start, c.offset);
                if (end >= start) {
                    indent = d.get(start, end - start);
                    buf.append(indent);
                } else {
                    buf.append(super.getAutoIndentAfterNewLine(d, c, change));
                }
            } else if ("__html_comment".equals(region.getType())) {
                infoParent = d.getLineInformationOfOffset(region.getOffset());
                IRegion infoParent2 = d.getLineInformationOfOffset(region.getOffset() + region.getLength());
                if (change && infoParent.getOffset() == infoParent2.getOffset() && c.offset > infoParent.getOffset() && c.length < 1) {
                    String indent = "";
                    int start = infoParent.getOffset();
                    int end = this.findEndOfWhiteSpace(d, start, c.offset);
                    if (end >= start) {
                        indent = d.get(start, end - start);
                        buf.append(c.text);
                        buf.append(String.valueOf(indent) + this.getIndentCharString());
                    }
                    c.caretOffset = c.offset + buf.length();
                    buf.append(c.text);
                    buf.append(super.getAutoIndentAfterNewLine(d, c, change));
                    int endOfWhiteSpace = this.findEndOfWhiteSpace(d, c.offset, infoParent.getOffset() + infoParent.getLength()) - c.offset;
                    d.replace(c.offset, endOfWhiteSpace, buf.toString());
                    return null;
                }
                buf.append(super.getAutoIndentAfterNewLine(d, c, change));
            } else {
                buf.append(super.getAutoIndentAfterNewLine(d, c, change));
            }
            if (region.getOffset() - 1 < 0) {
                return buf.toString();
            }
            ITypedRegion previousRegion_ = d.getPartition(region.getOffset() - 1);
            if (previousRegion_ == null) return buf.toString();
            String content = d.get(region.getOffset(), region.getLength());
            if (StringUtil.isNotBlank((String)content)) {
                return buf.toString();
            }
            int preLineNumber = d.getLineOfOffset(previousRegion_.getOffset());
            int nextOffset = region.getOffset() + region.getLength() + 1;
            if (nextOffset > d.getLength()) {
                return buf.toString();
            }
            ITypedRegion nextRegion = d.getPartition(region.getOffset() + region.getLength() + 1);
            if (nextRegion != null && preLineNumber == (nextLineNumber = d.getLineOfOffset(nextRegion.getOffset()))) {
                return buf.toString();
            }
            if (!previousRegion_.getType().startsWith("__html_")) {
                return buf.toString();
            }
            String previouContent = d.get(previousRegion_.getOffset(), previousRegion_.getLength());
            if (StringUtil.isBlank((String)previouContent)) {
                return buf.toString();
            }
            boolean isMatch = false;
            Set<String> mset = matchMap.keySet();
            String optStart = "";
            String optEnd = "";
            boolean isEndTag = TagUtil.isEndTag((String)previouContent);
            if (StringUtil.isBlank((String)(previouContent = TagUtil.getTagName((String)previouContent)))) {
                return buf.toString();
            }
            if (isEndTag) {
                previouContent = String.valueOf(previouContent) + "_end";
            }
            for (String matchPreviou : mset) {
                if (!previouContent.equals(matchPreviou)) continue;
                isMatch = true;
                optStart = matchMap.get(matchPreviou)[0];
                optEnd = matchMap.get(matchPreviou)[1];
                break;
            }
            if (!change || !isMatch) return buf.toString();
            String back = buf.toString();
            String result = String.valueOf(optStart) + optEnd;
            String x = "\r\n" + back;
            d.replace(c.offset, 0, x);
            c.caretOffset = c.offset + x.length();
            d.replace(c.offset + x.length(), 0, result);
            c.caretOffset += result.length() - optEnd.length();
            return null;
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
        }
        return buf.toString();
    }
}

