/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.text;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.contentassist.CommonTextHover;
import com.aptana.editor.common.hover.CustomBrowserInformationControl;
import com.aptana.editor.common.hover.DocumentationBrowserInformationControlInput;
import com.aptana.editor.css.parsing.ast.CSSSimpleSelectorNode;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.html.contentassist.HTMLModelFormatter;
import com.aptana.editor.html.contentassist.model.ElementElement;
import com.aptana.parsing.ast.IParseNode;
import java.util.Map;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorPart;

public class CSSElementSelectorHover
extends CommonTextHover
implements ITextHover,
ITextHoverExtension2 {
    private String fDocs;
    private String fHeader;

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        try {
            IParseNode activeNode = this.getActiveNode(textViewer, hoverRegion.getOffset());
            if (!(activeNode instanceof CSSSimpleSelectorNode)) {
                return null;
            }
            CSSSimpleSelectorNode node = (CSSSimpleSelectorNode)activeNode;
            ElementElement element = new HTMLIndexQueryHelper().getElement(node.getTypeSelector().toLowerCase());
            if (element != null) {
                this.fHeader = HTMLModelFormatter.TEXT_HOVER.getHeader(element);
                this.fDocs = HTMLModelFormatter.TEXT_HOVER.getDocumentation(element);
                DocumentationBrowserInformationControlInput documentationBrowserInformationControlInput = this.getHoverInfo(element, this.isBrowserControlAvailable(textViewer), null, (IEditorPart)this.getEditor(textViewer), hoverRegion);
                return documentationBrowserInformationControlInput;
            }
            return null;
        }
        finally {
            this.fHeader = null;
            this.fDocs = null;
        }
    }

    public String getHeader(Object element, IEditorPart editorPart, IRegion hoverRegion) {
        return this.fHeader;
    }

    public String getDocumentation(Object element, IEditorPart editorPart, IRegion hoverRegion) {
        return this.fDocs;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        ElementElement element;
        CSSSimpleSelectorNode node;
        String typeSelector;
        IParseNode activeNode = this.getActiveNode(textViewer, offset);
        if (activeNode instanceof CSSSimpleSelectorNode && !StringUtil.isEmpty((String)(typeSelector = (node = (CSSSimpleSelectorNode)activeNode).getTypeSelector())) && (element = new HTMLIndexQueryHelper().getElement(typeSelector.toLowerCase())) != null) {
            return new Region(node.getStartingOffset(), node.getLength());
        }
        return null;
    }

    public void populateToolbarActions(ToolBarManager tbm, CustomBrowserInformationControl iControl) {
    }

    public String getFileLocation(Object element, IEditorPart editorPart, IRegion hoverRegion) {
        return null;
    }

    public Map<String, String> getUserAgent(Object element, IEditorPart editorPart, IRegion hoverRegion) {
        return null;
    }

    public String getShowImage(Object element, IEditorPart editorPart, IRegion hoverRegion) {
        return null;
    }

    public String getBook(Object element, IEditorPart editorPart, IRegion hoverRegion) {
        return null;
    }
}

