/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.parsing.lexer;

import com.aptana.parsing.lexer.ITypePredicate;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum HTMLTokenType implements ITypePredicate
{
    UNDEFINED("undefined.html"),
    DOUBLE_QUOTED_STRING("string.quoted.double.html"),
    SINGLE_QUOTED_STRING("string.quoted.single.html"),
    ATTRIBUTE("entity.other.attribute-name.html"),
    ATTR_ID("entity.other.attribute-name.id.html"),
    ATTR_CLASS("entity.other.attribute-name.class.html"),
    ATTR_STYLE("entity.other.attribute-name.style.html"),
    ATTR_SCRIPT("entity.other.attribute-name.script.html"),
    META("meta.tag.other.html"),
    SCRIPT("entity.name.tag.script.html"),
    STYLE("entity.name.tag.style.html"),
    STRUCTURE_TAG("entity.name.tag.structure.any.html"),
    BLOCK_TAG("entity.name.tag.block.any.html"),
    INLINE_TAG("entity.name.tag.inline.any.html"),
    NEW_H5_TAG("entity.name.tag.new.h5.html"),
    TAG_END("punctuation.definition.tag.end.html"),
    EQUAL("punctuation.separator.key-value.html"),
    TAG_START("punctuation.definition.tag.begin.html"),
    TEXT("text"),
    TAG_SELF_CLOSE("punctuation.definition.tag.self_close.html");

    private static final Map<String, HTMLTokenType> NAME_MAP;
    private String _scope;
    private short _index;

    static {
        NAME_MAP = new HashMap<String, HTMLTokenType>();
        int index = 0;
        for (HTMLTokenType type : EnumSet.allOf(HTMLTokenType.class)) {
            NAME_MAP.put(type.getScope(), type);
            int n = index;
            index = (short)(n + 1);
            type._index = (short)n;
        }
    }

    public static final HTMLTokenType get(String scope) {
        return NAME_MAP.containsKey(scope) ? NAME_MAP.get(scope) : UNDEFINED;
    }

    private HTMLTokenType(String scope) {
        this._scope = scope;
    }

    public short getIndex() {
        return this._index;
    }

    public String getScope() {
        return this._scope;
    }

    public boolean isDefined() {
        return this != UNDEFINED;
    }

    public String toString() {
        return this.getScope();
    }
}

